/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.netbeans.modules.java.j2seplatform.wizard.DetectPanel;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class J2SEWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    private static final String[] SOLARIS_64_FOLDERS = new String[]{"sparcv9", "amd64"};
    DataFolder installFolder;
    DetectPanel.WizardPanel detectPanel;
    final ChangeSupport listeners = new ChangeSupport((Object)this);
    NewJ2SEPlatform platform;
    NewJ2SEPlatform secondaryPlatform;
    WizardDescriptor wizard;
    int currentIndex;

    public J2SEWizardIterator(FileObject installFolder) throws IOException {
        this.installFolder = DataFolder.findFolder((FileObject)installFolder);
        this.platform = NewJ2SEPlatform.create(installFolder);
        String archFolder = null;
        for (int i = 0; i < SOLARIS_64_FOLDERS.length; ++i) {
            if (Util.findTool("java", Collections.singleton(installFolder), SOLARIS_64_FOLDERS[i]) == null) continue;
            archFolder = SOLARIS_64_FOLDERS[i];
            break;
        }
        if (archFolder != null) {
            this.secondaryPlatform = NewJ2SEPlatform.create(installFolder);
            this.secondaryPlatform.setArchFolder(archFolder);
        }
    }

    FileObject getInstallFolder() {
        return this.installFolder.getPrimaryFile();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        switch (this.currentIndex) {
            case 0: {
                return this.detectPanel;
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wizard = wiz;
        this.detectPanel = new DetectPanel.WizardPanel(this);
        this.currentIndex = 0;
    }

    public Set instantiate() throws IOException {
        this.detectPanel.storeSettings(this.wizard);
        HashSet<JavaPlatform> result = new HashSet<JavaPlatform>();
        for (NewJ2SEPlatform platform : this.getPlatforms()) {
            if (!platform.isValid()) continue;
            try {
                result.add(PlatformConvertor.create(platform));
                if (result.size() != 1) continue;
                this.getInstallFolder().setAttribute("J2SEPlatform.displayName", (Object)platform.getDisplayName());
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalStateException(NbBundle.getMessage(J2SEWizardIterator.class, (String)"ERROR_InvalidName"));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public String name() {
        return NbBundle.getMessage(J2SEWizardIterator.class, (String)"TITLE_PlatformName");
    }

    public void nextPanel() {
        ++this.currentIndex;
    }

    public void previousPanel() {
        --this.currentIndex;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.removeChangeListener(l);
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wizard = null;
        this.detectPanel = null;
    }

    public NewJ2SEPlatform getPlatform() {
        return this.platform;
    }

    public NewJ2SEPlatform getSecondaryPlatform() {
        return this.secondaryPlatform;
    }

    private List<NewJ2SEPlatform> getPlatforms() {
        ArrayList<NewJ2SEPlatform> result = new ArrayList<NewJ2SEPlatform>();
        result.add(this.platform);
        if (this.secondaryPlatform != null) {
            result.add(this.secondaryPlatform);
        }
        return result;
    }
}

