/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.j2seplatform.libraries.J2SELibraryTypeProvider;
import org.netbeans.modules.java.j2seplatform.libraries.J2SEVolumeCustomizer;
import org.netbeans.modules.java.j2seplatform.queries.SourceJavadocAttacherUtil;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class J2SELibrarySourceJavadocAttacher
implements SourceJavadocAttacherImplementation {
    public boolean attachSources(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, "src");
    }

    public boolean attachJavadoc(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, "javadoc");
    }

    private boolean attach(final @NonNull URL root, final @NonNull SourceJavadocAttacher.AttachmentListener listener, final @NonNull String volume) {
        final Pair<LibraryManager, Library> pair = this.findOwner(root);
        if (pair == null) {
            return false;
        }
        Runnable call = new Runnable(){
            final /* synthetic */ J2SELibrarySourceJavadocAttacher this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LibraryManager lm = (LibraryManager)pair.first;
                Library lib = (Library)pair.second;
                assert (lm != null);
                assert (lib != null);
                boolean success = false;
                try {
                    List<? extends URI> selected;
                    File baseFolder;
                    URL areaLocation = lm.getLocation();
                    File file = baseFolder = areaLocation == null ? null : Utilities.toFile((URI)areaLocation.toURI()).getParentFile();
                    if (volume == "src") {
                        selected = SourceJavadocAttacherUtil.selectSources(root, lib.getURIContent(volume), new SelectFolder(volume, lib.getName(), baseFolder), new Convertor(volume, baseFolder), null);
                    } else if (volume == "javadoc") {
                        selected = SourceJavadocAttacherUtil.selectJavadoc(root, lib.getURIContent(volume), new SelectFolder(volume, lib.getName(), baseFolder), new Convertor(volume, baseFolder), null);
                    } else {
                        throw new IllegalStateException();
                    }
                    if (selected != null) {
                        String name = lib.getName();
                        String displayName = lib.getDisplayName();
                        String desc = lib.getDescription();
                        HashMap<String, ArrayList<? extends URI>> volumes = new HashMap<String, ArrayList<? extends URI>>();
                        for (String currentVolume : J2SELibraryTypeProvider.VOLUME_TYPES) {
                            ArrayList<? extends URI> content = lib.getURIContent(currentVolume);
                            if (volume == currentVolume) {
                                ArrayList<? extends URI> newContent;
                                content = newContent = new ArrayList<URI>(selected);
                            }
                            volumes.put(currentVolume, content);
                        }
                        Map props = lib.getProperties();
                        lm.removeLibrary(lib);
                        lm.createURILibrary("j2se", name, displayName, desc, volumes, props);
                        success = true;
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
                catch (URISyntaxException use) {
                    Exceptions.printStackTrace((Throwable)use);
                }
                finally {
                    SourceJavadocAttacherUtil.callListener(listener, success);
                }
            }
        };
        Mutex.EVENT.writeAccess(call);
        return true;
    }

    private Pair<LibraryManager, Library> findOwner(URL root) {
        for (LibraryManager lm : LibraryManager.getOpenManagers()) {
            for (Library l : lm.getLibraries()) {
                List cp;
                if (!"j2se".equals(l.getType()) || !(cp = l.getContent("classpath")).contains(root)) continue;
                return Pair.of(lm, l);
            }
        }
        return null;
    }

    private static class Pair<F, S> {
        public final F first;
        public final S second;

        private Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public static <F, S> Pair<F, S> of(F first, S second) {
            return new Pair<F, S>(first, second);
        }
    }

    private static class Convertor
    implements SourceJavadocAttacherUtil.Function<String, Collection<? extends URI>> {
        private final String volume;
        private final File baseFolder;

        private Convertor(@NonNull String volume, @NullAllowed File baseFolder) {
            Parameters.notNull((CharSequence)"volume", (Object)volume);
            this.volume = volume;
            this.baseFolder = baseFolder;
        }

        @Override
        public Collection<? extends URI> call(String param) throws Exception {
            FileObject paramFO;
            Collection<String> roots = Collections.singleton(param);
            File paramFile = new File(param);
            if (paramFile.isAbsolute() && paramFile.isDirectory() && (paramFO = FileUtil.toFileObject((File)paramFile)) != null) {
                switch (this.volume) {
                    case "src": {
                        ArrayList<String> sourceFolders = new ArrayList<String>();
                        for (FileObject fo : JavadocAndSourceRootDetection.findSourceRoots((FileObject)paramFO, null)) {
                            File f = FileUtil.toFile((FileObject)fo);
                            if (f == null) continue;
                            sourceFolders.add(f.getAbsolutePath());
                        }
                        if (sourceFolders.isEmpty()) break;
                        roots = sourceFolders;
                        break;
                    }
                    case "javadoc": {
                        ArrayList<String> javadocFolders = new ArrayList<String>();
                        for (FileObject fo : JavadocAndSourceRootDetection.findJavadocRoots((FileObject)paramFO, null)) {
                            File f = FileUtil.toFile((FileObject)fo);
                            if (f == null) continue;
                            javadocFolders.add(f.getAbsolutePath());
                        }
                        if (javadocFolders.isEmpty()) break;
                        roots = javadocFolders;
                    }
                }
            }
            ArrayList<URI> result = new ArrayList<URI>(roots.size());
            for (String root : roots) {
                URI uri = J2SEVolumeCustomizer.pathToURI(this.baseFolder, root, this.volume);
                if (uri == null) continue;
                result.add(uri);
            }
            return Collections.unmodifiableCollection(result);
        }
    }

    private static class SelectFolder
    implements Callable<List<? extends String>> {
        private final String volume;
        private final String libName;
        private final File baseFolder;

        private SelectFolder(@NonNull String volume, @NonNull String libName, @NullAllowed File baseFolder) {
            this.volume = volume;
            this.libName = libName;
            this.baseFolder = baseFolder;
        }

        @Override
        public List<? extends String> call() throws Exception {
            String[] paths = J2SEVolumeCustomizer.select(this.volume, this.libName, new File[1], null, this.baseFolder);
            return paths == null ? null : Arrays.asList(paths);
        }
    }
}

