/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ServiceLocatorStrategyPanel
extends JPanel
implements ChangeListener {
    public static final String IS_VALID = "ServiceLocatorStrategyPanel_isValid";
    private static final RequestProcessor RP = new RequestProcessor();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final ClasspathInfo cpInfo;
    private final String serviceLocatorName;
    private String errorMsg = null;
    private ButtonGroup buttonGroup1;
    private JTextField className;
    private JRadioButton existingServiceLocator;
    private JRadioButton noServiceLocator;
    private JButton showFindTypeButton;

    public ServiceLocatorStrategyPanel(String serviceLocatorName, ClasspathInfo cpInfo) {
        this.initComponents();
        this.cpInfo = cpInfo;
        this.serviceLocatorName = serviceLocatorName;
        this.changeSupport.addChangeListener((ChangeListener)this);
        this.className.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.fireChange();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.fireChange();
            }

            private void fireChange() {
                ServiceLocatorStrategyPanel.this.changeSupport.fireChange();
            }
        });
        if (serviceLocatorName != null) {
            this.existingServiceLocator.setSelected(true);
            this.className.setText(serviceLocatorName);
        } else {
            this.noServiceLocator.setSelected(true);
            this.setEnabledClassNameTextField(false);
        }
    }

    public String classSelected() {
        return this.existingServiceLocator.isSelected() ? this.className.getText() : null;
    }

    public JRadioButton getUnreferencedServiceLocator() {
        return this.existingServiceLocator;
    }

    public JTextField getClassName() {
        return this.className;
    }

    private boolean validClass() {
        if (this.existingServiceLocator.isSelected()) {
            AtomicBoolean classExists = new AtomicBoolean(false);
            JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            if (javaSource != null) {
                try {
                    ValidClassChecker classChecker = new ValidClassChecker(classExists);
                    Future future = javaSource.runWhenScanFinished((Task)classChecker, true);
                    if (future.isDone()) {
                        return classExists.get();
                    }
                    javaSource.runUserActionTask((Task)classChecker, true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return classExists.get();
        }
        return true;
    }

    private boolean validClassExists(CompilationController controller, String className) {
        TypeElement typeElement = controller.getElements().getTypeElement(className);
        if (typeElement != null) {
            return typeElement.getKind().isClass();
        }
        return false;
    }

    public boolean verifyComponents() {
        this.errorMsg = this.validClass() ? null : Bundle.serviceLocatorStrategyPanel_error_class_not_valid();
        return this.errorMsg == null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.verifyComponents()) {
            this.firePropertyChange(IS_VALID, false, true);
        } else {
            this.firePropertyChange(IS_VALID, true, false);
        }
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.noServiceLocator = new JRadioButton();
        this.existingServiceLocator = new JRadioButton();
        this.className = new JTextField();
        this.showFindTypeButton = new JButton();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle");
        this.setBorder(BorderFactory.createTitledBorder(bundle.getString("LBL_ServiceLocatorStrategy")));
        this.buttonGroup1.add(this.noServiceLocator);
        this.noServiceLocator.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.noServiceLocator, (String)bundle.getString("LBL_NoServiceLocator"));
        this.noServiceLocator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServiceLocatorStrategyPanel.this.noLocatorActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.existingServiceLocator);
        Mnemonics.setLocalizedText((AbstractButton)this.existingServiceLocator, (String)bundle.getString("LBL_UseServiceLocatorClass"));
        this.existingServiceLocator.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ServiceLocatorStrategyPanel.this.existingServiceLocatorItemStateChanged(evt);
            }
        });
        this.existingServiceLocator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServiceLocatorStrategyPanel.this.existingClassActionPerformed(evt);
            }
        });
        this.showFindTypeButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle").getString("MN_Browse").charAt(0));
        this.showFindTypeButton.setText("...");
        this.showFindTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServiceLocatorStrategyPanel.this.showFindTypeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noServiceLocator).addGroup(layout.createSequentialGroup().addComponent(this.existingServiceLocator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.className, -2, 209, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showFindTypeButton))).addContainerGap(16, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.noServiceLocator).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.existingServiceLocator).addComponent(this.className, -2, -1, -2).addComponent(this.showFindTypeButton))));
        this.noServiceLocator.getAccessibleContext().setAccessibleName("&Generator inline lookup code");
        this.noServiceLocator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServiceLocatorStrategyPanel.class, (String)"ACSD_NoServiceLocator"));
        this.existingServiceLocator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServiceLocatorStrategyPanel.class, (String)"ACSD_UseServiceLocatorClass"));
        this.className.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ExistingClassName"));
        this.className.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ExistingClassName"));
        this.showFindTypeButton.getAccessibleContext().setAccessibleName(bundle.getString("ACS_Browse"));
        this.showFindTypeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_Browse"));
    }

    private void showFindTypeButtonActionPerformed(ActionEvent evt) {
        ElementHandle handle;
        this.existingServiceLocator.setSelected(true);
        this.setEnabledClassNameTextField(true);
        String simpleName = "";
        if (this.serviceLocatorName != null) {
            int dotPosition = this.serviceLocatorName.lastIndexOf(".");
            simpleName = this.serviceLocatorName.substring(dotPosition + 1);
        }
        if ((handle = TypeElementFinder.find((ClasspathInfo)this.cpInfo, (String)simpleName, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
            }

            public boolean accept(ElementHandle<TypeElement> typeHandle) {
                return true;
            }
        })) != null) {
            this.className.setText(handle.getQualifiedName());
        }
    }

    private void existingServiceLocatorItemStateChanged(ItemEvent evt) {
        this.changeSupport.fireChange();
    }

    private void noLocatorActionPerformed(ActionEvent evt) {
        this.setEnabledClassNameTextField(false);
        this.changeSupport.fireChange();
    }

    private void existingClassActionPerformed(ActionEvent evt) {
        this.setEnabledClassNameTextField(true);
        this.changeSupport.fireChange();
    }

    private void setEnabledClassNameTextField(boolean enabled) {
        this.className.setEnabled(enabled);
    }

    private class ValidClassChecker
    implements Task<CompilationController> {
        private final AtomicBoolean wasScanning = new AtomicBoolean(false);
        private final AtomicBoolean classExists;

        public ValidClassChecker(AtomicBoolean classExists) {
            this.classExists = classExists;
        }

        public void run(CompilationController parameter) throws Exception {
            parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            this.classExists.set(ServiceLocatorStrategyPanel.this.validClassExists(parameter, ServiceLocatorStrategyPanel.this.className.getText()));
            if (this.wasScanning.get()) {
                ServiceLocatorStrategyPanel.this.changeSupport.fireChange();
            }
            this.wasScanning.set(true);
        }
    }
}

