/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CharInput;
import org.netbeans.api.languages.Language;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.parser.Pattern;

public class Parser {
    public static final String DEFAULT_STATE = "DEFAULT";
    private Map<Integer, Pattern> stateToPattern = new HashMap<Integer, Pattern>();
    private Map<String, Integer> nameToState = new HashMap<String, Integer>();
    private Map<Integer, String> stateToName = new HashMap<Integer, String>();
    private List<TokenType> tokenTypes;
    private int counter = 1;
    private Map<String, Pattern> patterns;

    private Parser() {
        this.nameToState.put(DEFAULT_STATE, -1);
        this.stateToName.put(-1, DEFAULT_STATE);
        this.patterns = new HashMap<String, Pattern>();
    }

    public static Parser create(List<TokenType> rules) {
        return new Parser(rules);
    }

    private Parser(List<TokenType> tokenTypes) {
        this.nameToState.put(DEFAULT_STATE, -1);
        this.stateToName.put(-1, DEFAULT_STATE);
        this.patterns = new HashMap<String, Pattern>();
        this.tokenTypes = tokenTypes;
        for (TokenType r : tokenTypes) {
            this.add(r);
        }
    }

    public List<TokenType> getTokenTypes() {
        return this.tokenTypes;
    }

    private void add(TokenType tokenType) {
        if (tokenType.getPattern() == null) {
            return;
        }
        String startState = tokenType.getStartState();
        if (startState == null) {
            startState = DEFAULT_STATE;
        }
        int state = 0;
        if (this.nameToState.containsKey(startState)) {
            state = this.nameToState.get(startState);
        } else {
            state = this.counter++;
            this.nameToState.put(startState, state);
            this.stateToName.put(state, startState);
        }
        Pattern pattern = tokenType.getPattern();
        pattern.mark(tokenType.getPriority(), tokenType);
        if (this.stateToPattern.containsKey(state)) {
            this.stateToPattern.put(state, this.stateToPattern.get(state).merge(pattern));
        } else {
            this.stateToPattern.put(state, pattern);
        }
    }

    public ASTToken read(Cookie cookie, CharInput input, Language language) {
        if (input.eof()) {
            return null;
        }
        int originalIndex = input.getIndex();
        Pattern pattern = this.stateToPattern.get(cookie.getState());
        if (pattern == null) {
            return null;
        }
        TokenType tokenType = (TokenType)pattern.read(input);
        if (tokenType == null) {
            return null;
        }
        Feature tokenProperties = tokenType.getProperties();
        cookie.setProperties(tokenProperties);
        String endState = tokenType.getEndState();
        int state = -1;
        if (endState != null) {
            state = this.getState(endState);
        }
        cookie.setState(state);
        ASTToken token = ASTToken.create(language, tokenType.getTypeID(), input.getString(originalIndex, input.getIndex()), originalIndex);
        if (tokenProperties != null && tokenProperties.getType("call") != Feature.Type.NOT_SET) {
            input.setIndex(originalIndex);
            Object[] r = (Object[])tokenProperties.getValue("call", new Object[]{input});
            if (r == null) {
                throw new NullPointerException("Method " + tokenProperties.getMethodName("call") + " returns null!\n");
            }
            token = (ASTToken)r[0];
            if (r[1] != null) {
                cookie.setState(this.getState((String)r[1]));
            }
        }
        return token;
    }

    public int getState(String stateName) {
        Integer i = this.nameToState.get(stateName);
        if (i == null) {
            throw new IllegalArgumentException("Unknown lexer state: " + stateName);
        }
        return i;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String state : this.patterns.keySet()) {
            sb.append(state).append(":").append(this.patterns.get(state));
        }
        return sb.toString();
    }

    public static interface Cookie {
        public int getState();

        public void setState(int var1);

        public void setProperties(Feature var1);
    }
}

