/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.features.LocalizationSupport;
import org.openide.ErrorManager;
import org.openide.text.Annotation;

public class AnnotationManager
extends ASTEvaluator {
    private NbEditorDocument doc;
    private ParserManager parser;
    private List<ASTItem> items;
    private List<Feature> marks;
    private List<LanguagesAnnotation> annotations = new ArrayList<LanguagesAnnotation>();

    public AnnotationManager(Document doc) {
        this.doc = (NbEditorDocument)doc;
        if (doc == null) {
            throw new NullPointerException();
        }
        this.parser = ParserManager.get(doc);
        this.parser.addASTEvaluator(this);
    }

    @Override
    public String getFeatureName() {
        return "MARK";
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode root) {
        this.items = new ArrayList<ASTItem>();
        this.marks = new ArrayList<Feature>();
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode root) {
        this.refresh(this.items, this.marks);
    }

    @Override
    public void evaluate(ParserManager.State state, List<ASTItem> path, Feature feature) {
        if (feature.getBoolean("condition", SyntaxContext.create((Document)this.doc, ASTPath.create(path)), true)) {
            this.items.add(path.get(path.size() - 1));
            this.marks.add(feature);
        }
    }

    public void remove() {
        this.removeAnnotations();
        this.parser.removeASTEvaluator(this);
    }

    private void removeAnnotations() {
        Iterator<LanguagesAnnotation> it = this.annotations.iterator();
        while (it.hasNext()) {
            this.doc.removeAnnotation((Annotation)it.next());
        }
    }

    private void refresh(final List<ASTItem> items, final List<Feature> marks) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ AnnotationManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    ArrayList<LanguagesAnnotation> newAnnotations = new ArrayList<LanguagesAnnotation>();
                    Iterator it = this.this$0.annotations.iterator();
                    LanguagesAnnotation oldAnnotation = it.hasNext() ? (LanguagesAnnotation)((Object)it.next()) : null;
                    Iterator it2 = items.iterator();
                    Iterator it3 = marks.iterator();
                    int count = 0;
                    while (it2.hasNext() && count < 100) {
                        ASTItem item = (ASTItem)it2.next();
                        Feature mark = (Feature)it3.next();
                        String message = (String)mark.getValue("message");
                        Language language = (Language)item.getLanguage();
                        message = LocalizationSupport.localize(language, message);
                        String type = (String)mark.getValue("type");
                        while (oldAnnotation != null && oldAnnotation.getPosition().getOffset() < item.getOffset()) {
                            this.this$0.doc.removeAnnotation((Annotation)oldAnnotation);
                            oldAnnotation = it.hasNext() ? (LanguagesAnnotation)((Object)it.next()) : null;
                        }
                        ++count;
                        if (oldAnnotation != null && oldAnnotation.getPosition().getOffset() == item.getOffset() && oldAnnotation.getAnnotationType().equals(type) && oldAnnotation.getShortDescription().equals(message)) {
                            newAnnotations.add(oldAnnotation);
                            oldAnnotation = it.hasNext() ? (LanguagesAnnotation)((Object)it.next()) : null;
                            continue;
                        }
                        LanguagesAnnotation la = new LanguagesAnnotation(type, message);
                        if (item.getLength() == 0) {
                            TokenHierarchy hi = TokenHierarchy.get((Document)this.this$0.doc);
                            TokenSequence ts = hi.tokenSequence();
                            ts.move(item.getOffset());
                            if (!(ts.moveNext() && this.this$0.testCreateAnnotation(hi, ts, item, la) || ts.movePrevious() && this.this$0.testCreateAnnotation(hi, ts, item, la))) {
                                Position position = this.this$0.doc.createPosition(item.getOffset());
                                la.setPosition(position);
                                this.this$0.doc.addAnnotation(this.this$0.doc.createPosition(item.getOffset()), item.getLength(), (Annotation)la);
                            }
                        } else {
                            Position position = this.this$0.doc.createPosition(item.getOffset());
                            la.setPosition(position);
                            this.this$0.doc.addAnnotation(this.this$0.doc.createPosition(item.getOffset()), item.getLength(), (Annotation)la);
                        }
                        newAnnotations.add(la);
                    }
                    if (oldAnnotation != null) {
                        this.this$0.doc.removeAnnotation((Annotation)oldAnnotation);
                    }
                    while (it.hasNext()) {
                        this.this$0.doc.removeAnnotation((Annotation)it.next());
                    }
                    this.this$0.annotations = newAnnotations;
                }
                catch (BadLocationException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        });
    }

    private boolean testCreateAnnotation(TokenHierarchy hi, TokenSequence ts, ASTItem item, LanguagesAnnotation la) throws BadLocationException {
        if (ts.language() == null) {
            throw new NullPointerException("ts.language()==null");
        }
        if (ts.language().mimeType() == null) {
            throw new NullPointerException("TokenSequence.mimeType==null");
        }
        if (ts.language().mimeType().equals(item.getMimeType())) {
            Token t = ts.token();
            if (t == null) {
                throw new NullPointerException();
            }
            Position position = this.doc.createPosition(t.offset(hi));
            la.setPosition(position);
            this.doc.addAnnotation(position, t.length(), (Annotation)la);
            return true;
        }
        if ((ts = ts.embedded()) == null) {
            return false;
        }
        return ts.moveNext() ? this.testCreateAnnotation(hi, ts, item, la) : false;
    }

    static class LanguagesAnnotation
    extends Annotation {
        private String type;
        private String description;
        private Position position;

        LanguagesAnnotation(String type, String description) {
            this.type = type;
            this.description = description;
            if (type == null) {
                throw new NullPointerException();
            }
            if (description == null) {
                throw new NullPointerException();
            }
        }

        public String getAnnotationType() {
            return this.type;
        }

        public String getShortDescription() {
            return this.description;
        }

        void setPosition(Position position) {
            this.position = position;
        }

        Position getPosition() {
            return this.position;
        }
    }
}

