/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.jsf.refactoring.DiffElement;
import org.netbeans.modules.web.jsf.refactoring.JSFRefactoringUtils;
import org.netbeans.modules.web.jsf.refactoring.Modifications;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.PositionBounds;

public class JSFRenamePlugin
extends JavaRefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private TreePathHandle treePathHandle = null;
    private static final Logger LOGGER = Logger.getLogger(JSFRenamePlugin.class.getName());
    private final RenameRefactoring refactoring;

    public JSFRenamePlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        LOGGER.fine("preCheck() called.");
        return null;
    }

    public Problem checkParameters() {
        LOGGER.fine("checkParameters() called.");
        return null;
    }

    public Problem fastCheckParameters() {
        LOGGER.fine("fastCheckParameters() called.");
        return null;
    }

    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() == null) {
            Project project;
            semafor.set(new Object());
            FileObject fileObject = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            NonRecursiveFolder nonRecursivefolder = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
            this.treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
            if (fileObject != null && (JSFRefactoringUtils.isJavaFile(fileObject) || fileObject.isFolder())) {
                JavaSource source;
                if (fileObject.isFolder()) {
                    String prefix;
                    ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                    if (classPath == null) {
                        return null;
                    }
                    FileObject root = classPath.findOwnerRoot(fileObject);
                    String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fileObject.getParent());
                    if (relativePath == null) {
                        relativePath = "";
                    }
                    String oldName = (prefix = relativePath.replace('/', '.')).length() == 0 ? fileObject.getName() : prefix + "." + fileObject.getName();
                    String newName = prefix.length() == 0 ? this.refactoring.getNewName() : prefix + "." + this.refactoring.getNewName();
                    JSFRefactoringUtils.renamePackage((AbstractRefactoring)this.refactoring, refactoringElements, fileObject, oldName, newName, true);
                } else if (JSFRefactoringUtils.isJavaFile(fileObject) && (source = JavaSource.forFileObject((FileObject)fileObject)) != null) {
                    try {
                        source.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController co) throws Exception {
                                co.toPhase(JavaSource.Phase.RESOLVED);
                                CompilationUnitTree cut = co.getCompilationUnit();
                                if (!cut.getTypeDecls().isEmpty()) {
                                    JSFRenamePlugin.this.treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(cut, cut.getTypeDecls().get(0)), (CompilationInfo)co);
                                }
                            }
                        }, false);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.log(Level.WARNING, "Exception in JSFRenamePlugin", ex);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, "Exception in JSFRenamePlugin", ex);
                    }
                }
            }
            if (nonRecursivefolder != null) {
                String oldName = JSFRefactoringUtils.getPackageName(nonRecursivefolder.getFolder());
                String newName = this.refactoring.getNewName();
                JSFRefactoringUtils.renamePackage((AbstractRefactoring)this.refactoring, refactoringElements, nonRecursivefolder.getFolder(), oldName, newName, false);
            }
            if (this.treePathHandle != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)this.treePathHandle.getKind()) && (project = FileOwnerQuery.getOwner((FileObject)this.treePathHandle.getFileObject())) != null) {
                Element resElement = JSFRefactoringUtils.resolveElement(this.getClasspathInfo((AbstractRefactoring)this.refactoring), (AbstractRefactoring)this.refactoring, this.treePathHandle);
                if (resElement == null) {
                    return null;
                }
                TypeElement type = (TypeElement)resElement;
                String oldFQN = type.getQualifiedName().toString();
                String newFQN = JSFRenamePlugin.renameClass(oldFQN, this.refactoring.getNewName());
                List<Occurrences.OccurrenceItem> items = Occurrences.getAllOccurrences(project, oldFQN, newFQN);
                Modifications modification = new Modifications();
                for (Occurrences.OccurrenceItem item : items) {
                    PositionBounds position = item.getChangePosition();
                    Modifications.Difference difference = new Modifications.Difference(Modifications.Difference.Kind.CHANGE, position.getBegin(), position.getEnd(), oldFQN, newFQN, item.getChangeMessage());
                    modification.addDifference(item.getFacesConfig(), difference);
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new DiffElement.ChangeFQCNElement(difference, item, modification));
                }
            }
            semafor.set(null);
        }
        return null;
    }

    private static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    private static String renameClass(String originalFullyQualifiedName, String newName) {
        if (JSFRenamePlugin.isEmpty(originalFullyQualifiedName) || JSFRenamePlugin.isEmpty(newName)) {
            throw new IllegalArgumentException("Old and new name of the class must be given.");
        }
        int lastDot = originalFullyQualifiedName.lastIndexOf(46);
        if (lastDot <= 0) {
            return newName;
        }
        return originalFullyQualifiedName.substring(0, lastDot + 1) + newName;
    }
}

