/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.transform;

import com.sun.xml.wss.impl.c14n.Canonicalizer;
import com.sun.xml.wss.impl.c14n.CanonicalizerFactory;
import com.sun.xml.wss.impl.c14n.MimeHeaderCanonicalizer;
import com.sun.xml.wss.impl.dsig.AttachmentData;
import com.sun.xml.wss.impl.misc.UnsyncByteArrayOutputStream;
import com.sun.xml.wss.logging.impl.dsig.LogStringsMessages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;

public class ACTransform
extends TransformService {
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");

    @Override
    public void init(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
    }

    @Override
    public void init(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws InvalidAlgorithmParameterException {
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec() {
        return null;
    }

    @Override
    public void marshalParams(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
    }

    private Data canonicalize(AttachmentData attachmentData, OutputStream outputStream) throws TransformException {
        try {
            AttachmentPart attachment = attachmentData.getAttachmentPart();
            Iterator<MimeHeader> mimeHeaders = attachment.getAllMimeHeaders();
            MimeHeaderCanonicalizer mHCanonicalizer = CanonicalizerFactory.getMimeHeaderCanonicalizer("US-ASCII");
            byte[] outputHeaderBytes = mHCanonicalizer._canonicalize(mimeHeaders);
            OutputStream byteStream = new UnsyncByteArrayOutputStream();
            attachment.getDataHandler().writeTo(byteStream);
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)byteStream).toByteArray());
            ((OutputStream)byteStream).close();
            byteStream = outputStream == null ? new ByteArrayOutputStream() : outputStream;
            ((OutputStream)byteStream).write(outputHeaderBytes);
            Canonicalizer canonicalizer = CanonicalizerFactory.getCanonicalizer(attachment.getContentType());
            InputStream is = canonicalizer.canonicalize(byteInputStream, byteStream);
            if (is != null) {
                return new OctetStreamData(is);
            }
            return null;
        }
        catch (TransformException te) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1319_ACO_TRANSFORM_ERROR(), te);
            throw te;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1319_ACO_TRANSFORM_ERROR(), ex);
            throw new TransformException(ex.getMessage());
        }
    }

    @Override
    public boolean isFeatureSupported(String str) {
        return false;
    }

    @Override
    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        if (data instanceof AttachmentData) {
            try {
                return this.canonicalize((AttachmentData)data, null);
            }
            catch (TransformException tex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1319_ACO_TRANSFORM_ERROR(), tex);
                throw tex;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1319_ACO_TRANSFORM_ERROR(), ex);
                throw new RuntimeException(ex);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Data transform(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        if (data instanceof AttachmentData) {
            return this.canonicalize((AttachmentData)data, outputStream);
        }
        throw new UnsupportedOperationException();
    }
}

