/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.netbeans.jemmy.JemmyException;
import org.openide.util.NbBundle;

public class Bundle {
    private Bundle() {
        throw new Error("Bundle is just a container for static methods");
    }

    public static ResourceBundle getBundle(String bundle) {
        try {
            return NbBundle.getBundle((String)bundle);
        }
        catch (NullPointerException e) {
            throw new JemmyException("\"" + bundle + "\" bundle was not found", (Throwable)e);
        }
        catch (MissingResourceException e) {
            throw new JemmyException("\"" + bundle + "\" bundle was not found", (Throwable)e);
        }
    }

    public static String getString(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            throw new JemmyException("\"" + key + "\" key was not found", (Throwable)e);
        }
        catch (NullPointerException npe) {
            throw new JemmyException("Cannot accept null parameter.", (Throwable)npe);
        }
    }

    public static String getString(ResourceBundle bundle, String key, Object[] params) {
        return MessageFormat.format(Bundle.getString(bundle, key), params);
    }

    public static String getString(String bundle, String key) {
        return Bundle.getString(Bundle.getBundle(bundle), key);
    }

    public static String getStringTrimmed(String bundle, String key) {
        return Bundle.trim(Bundle.getString(Bundle.getBundle(bundle), key));
    }

    public static String getString(String bundle, String key, Object[] params) {
        return MessageFormat.format(Bundle.getString(bundle, key), params);
    }

    public static String getStringTrimmed(String bundle, String key, Object[] params) {
        return Bundle.trim(Bundle.getString(Bundle.getBundle(bundle), key, params));
    }

    private static String trim(String value) {
        if ((value = Bundle.cutAmpersand(value)).indexOf(123) != -1) {
            value = value.substring(0, value.indexOf(123));
        }
        return value;
    }

    private static String cutAmpersand(String text) {
        String result = text;
        int i = text.indexOf("(&");
        result = i >= 0 && i + 3 < text.length() && text.charAt(i + 3) == ')' ? text.substring(0, i) : ((i = text.indexOf(38)) < 0 ? text : (i == text.length() - 1 ? text.substring(0, i) : text.substring(0, i) + text.substring(i + 1)));
        return result;
    }
}

