/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProjectReference;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

class UpdateEclipseReferencePanel
extends JPanel
implements DocumentListener {
    private DialogDescriptor dd;
    private String projName;
    private JButton browseProjectButton;
    private JButton browseWorkspaceButton;
    private JTextField eclipseProjectTextField;
    private JTextField eclipseWorkspaceTextField;
    private JLabel error;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;

    private UpdateEclipseReferencePanel(EclipseProjectReference reference) {
        this.projName = ((ProjectInformation)reference.getProject().getLookup().lookup(ProjectInformation.class)).getDisplayName();
        this.initComponents();
        this.eclipseProjectTextField.setText(reference.getEclipseProjectLocation().getPath());
        boolean enabled = !reference.getEclipseProjectLocation().exists() || !EclipseUtils.isRegularProject(reference.getEclipseProjectLocation());
        this.eclipseProjectTextField.setEnabled(enabled);
        this.browseProjectButton.setEnabled(enabled);
        enabled = !reference.getEclipseWorkspaceLocation().exists() || !EclipseUtils.isRegularWorkSpace(reference.getEclipseWorkspaceLocation());
        this.eclipseWorkspaceTextField.setText(reference.getEclipseWorkspaceLocation().getPath());
        this.eclipseWorkspaceTextField.setEnabled(enabled);
        this.browseWorkspaceButton.setEnabled(enabled);
    }

    public void setDialogDescriptor(DialogDescriptor dd) {
        this.dd = dd;
        this.eclipseProjectTextField.getDocument().addDocumentListener(this);
        this.eclipseWorkspaceTextField.getDocument().addDocumentListener(this);
        this.updateStatus();
    }

    private void updateStatus() {
        String errorMsg = null;
        if (this.eclipseProjectTextField.isEnabled() && !EclipseUtils.isRegularProject(this.eclipseProjectTextField.getText())) {
            errorMsg = NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"MSG_SelectProject");
        }
        if (errorMsg == null && this.eclipseWorkspaceTextField.isEnabled()) {
            String d = this.eclipseWorkspaceTextField.getText();
            if (d == null || d.trim().length() == 0) {
                errorMsg = NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"MSG_SelectWorkspace");
            } else if (!EclipseUtils.isRegularWorkSpace(FileUtil.normalizeFile((File)new File(d.trim())))) {
                errorMsg = NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"MSG_SelectWorkspace");
            }
        }
        this.dd.setValid(errorMsg == null);
        this.error.setText(errorMsg == null ? " " : errorMsg);
    }

    public static boolean showEclipseReferenceResolver(@NonNull EclipseProjectReference ref, @NonNull Map<String, String> resolvedEntries) {
        File workspace = ref.getEclipseWorkspaceLocation();
        if (workspace != null && !workspace.exists() && resolvedEntries.get(workspace.getPath()) != null) {
            ref.updateReference(null, resolvedEntries.get(workspace.getPath()));
        }
        if (!ref.getEclipseProjectLocation().exists() && resolvedEntries.get(ref.getEclipseProjectLocation().getParent()) != null) {
            File f = new File(resolvedEntries.get(ref.getEclipseProjectLocation().getParent()));
            if ((f = new File(f, ref.getEclipseProjectLocation().getName())).exists()) {
                ref.updateReference(f.getPath(), null);
            }
        }
        if (ref.isEclipseProjectReachable()) {
            return true;
        }
        UpdateEclipseReferencePanel p = new UpdateEclipseReferencePanel(ref);
        DialogDescriptor dd = new DialogDescriptor((Object)p, NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"TITLE_Synchronize_with_Eclipse"), true, 2, null, null);
        p.setDialogDescriptor(dd);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            if (p.eclipseProjectTextField.isEnabled()) {
                resolvedEntries.put(ref.getEclipseProjectLocation().getParent(), p.eclipseProjectTextField.getText());
            }
            if (workspace != null && p.eclipseWorkspaceTextField.isEnabled()) {
                resolvedEntries.put(workspace.getPath(), p.eclipseWorkspaceTextField.getText());
            }
            ref.updateReference(p.eclipseProjectTextField.isEnabled() ? p.eclipseProjectTextField.getText() : null, p.eclipseWorkspaceTextField.isEnabled() ? p.eclipseWorkspaceTextField.getText() : null);
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.eclipseProjectTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.eclipseWorkspaceTextField = new JTextField();
        this.browseProjectButton = new JButton();
        this.browseWorkspaceButton = new JButton();
        this.error = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel1.setLabelFor(this.eclipseProjectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.jLabel1.text"));
        this.eclipseProjectTextField.setText(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.eclipseProjectTextField.text"));
        this.jLabel2.setLabelFor(this.eclipseWorkspaceTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.jLabel2.text"));
        this.eclipseWorkspaceTextField.setText(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.eclipseWorkspaceTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseProjectButton, (String)NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.browseProjectButton.text"));
        this.browseProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateEclipseReferencePanel.this.browseProjectButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.browseWorkspaceButton, (String)NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.browseWorkspaceButton.text"));
        this.browseWorkspaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateEclipseReferencePanel.this.browseWorkspaceButtonActionPerformed(evt);
            }
        });
        this.error.setForeground(Color.red);
        Mnemonics.setLocalizedText((JLabel)this.error, (String)" ");
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.jLabel3.text", (Object)this.projName));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.jLabel4.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, 576, Short.MAX_VALUE).addComponent(this.jLabel4, -1, 576, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.eclipseProjectTextField, -1, 319, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseProjectButton)).addGroup(layout.createSequentialGroup().addComponent(this.eclipseWorkspaceTextField, -1, 319, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseWorkspaceButton)))).addComponent(this.error, -1, 576, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, -1, -2).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.eclipseProjectTextField, -2, -1, -2).addComponent(this.browseProjectButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eclipseWorkspaceTextField, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.browseWorkspaceButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.error).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
        this.eclipseProjectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
        this.eclipseWorkspaceTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
        this.browseProjectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
        this.browseWorkspaceButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
        this.error.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
        this.error.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"ACSD_UpdateEclipseReferencePanel_NA"));
    }

    private void browseProjectButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"TITLE_Select_Eclipse_Project"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.eclipseProjectTextField.setText(file.getAbsolutePath());
        }
    }

    private void browseWorkspaceButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"TITLE_Select_Eclipse_Workspace"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.eclipseWorkspaceTextField.setText(file.getAbsolutePath());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.updateStatus();
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.updateStatus();
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
    }
}

