/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.netbeans.modules.db.api.sql.SQLKeywords;
import org.netbeans.modules.j2ee.jpa.model.JPAHelper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.IdDefinedInHierarchy;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class ValidPrimaryTableName {
    public static ErrorDescription apply(HintContext hc) {
        TreePath par;
        if (hc.isCanceled() || hc.getPath().getLeaf().getKind() != Tree.Kind.IDENTIFIER || hc.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return null;
        }
        JPAProblemContext ctx = ModelUtils.getOrCreateCachedContext(hc);
        if (ctx == null || hc.isCanceled()) {
            return null;
        }
        Object me = ctx.getModelElement();
        if (me == null || !(me instanceof Entity)) {
            return null;
        }
        String tableName = JPAHelper.getPrimaryTableName((Entity)me);
        if (tableName == null) {
            return null;
        }
        String entityName = ((Entity)me).getName();
        for (par = hc.getPath(); par != null && par.getParentPath() != null && par.getLeaf().getKind() != Tree.Kind.CLASS; par = par.getParentPath()) {
        }
        Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), par.getLeaf());
        if (tableName.length() == 0) {
            return ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_InvalidPersistenceQLIdentifier"), (Fix[])new Fix[0]);
        }
        if (SQLKeywords.isSQL99ReservedKeyword((String)tableName)) {
            return ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_ClassNamedWithReservedSQLKeyword"), (Fix[])new Fix[0]);
        }
        if (JavaPersistenceQLKeywords.isKeyword((String)entityName)) {
            return ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_ClassNamedWithJavaPersistenceQLKeyword"), (Fix[])new Fix[0]);
        }
        return null;
    }
}

