/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.logging.Level;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreatePersistenceUnit;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ImplementSerializable
implements Fix {
    private FileObject fileObject;
    private ElementHandle<TypeElement> classHandle;

    public ImplementSerializable(FileObject fileObject, ElementHandle<TypeElement> classHandle) {
        this.classHandle = classHandle;
        this.fileObject = fileObject;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement clazz = (TypeElement)ImplementSerializable.this.classHandle.resolve((CompilationInfo)workingCopy);
                if (clazz != null) {
                    ClassTree clazzTree = workingCopy.getTrees().getTree(clazz);
                    GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    ClassTree modifiedClazz = genUtils.addImplementsClause(clazzTree, "java.io.Serializable");
                    workingCopy.rewrite((Tree)clazzTree, (Tree)modifiedClazz);
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)task).commit();
        }
        catch (IOException e) {
            JPAProblemFinder.LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String getText() {
        return NbBundle.getMessage(CreatePersistenceUnit.class, (String)"LBL_ImplementSerializable");
    }
}

