/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.ext.GotoDialogSupport;
import org.netbeans.editor.ext.KeyEventBlocker;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;

public final class StatusLineComponent
extends JLabel {
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    private static final String MAX_LINE_COLUMN_STRING = "99999:999/9999:9999";
    private static final String MAX_LINE_COLUMN_OFFSET_STRING = "99999:999/9999:9999 <99999999>";
    private static final String INSERT_LOCALE = "status-bar-insert";
    private static final String OVERWRITE_LOCALE = "status-bar-overwrite";
    private static final Logger LOG = Logger.getLogger(StatusLineComponent.class.getName());
    private static final Logger CARET_OFFSET_LOG = Logger.getLogger("org.netbeans.editor.caret.offset");
    private Dimension minDimension;

    StatusLineComponent(Type type) {
        switch (type.ordinal()) {
            case 0: {
                this.initMinDimension(CARET_OFFSET_LOG.isLoggable(Level.FINE) ? MAX_LINE_COLUMN_OFFSET_STRING : MAX_LINE_COLUMN_STRING);
                break;
            }
            case 1: {
                ResourceBundle bundle = NbBundle.getBundle(BaseKit.class);
                String insText = bundle.getString(INSERT_LOCALE);
                String ovrText = bundle.getString(OVERWRITE_LOCALE);
                this.initMinDimension(insText, ovrText);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.setHorizontalAlignment(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTextComponent lastFocusedComponent;
                if (MouseUtils.isDoubleClick((MouseEvent)e) && (lastFocusedComponent = EditorRegistry.lastFocusedComponent()) != null) {
                    new GotoDialogSupport().showGotoDialog(new KeyEventBlocker(lastFocusedComponent, false));
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return this.minDimension;
    }

    private void initMinDimension(String ... maxStrings) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int minWidth = 0;
        for (String s : maxStrings) {
            minWidth = Math.max(minWidth, fm.stringWidth(s));
        }
        Border b = this.getBorder();
        Insets ins = b != null ? b.getBorderInsets(this) : NULL_INSETS;
        int minHeight = fm.getHeight() + ins.top + ins.bottom;
        this.minDimension = new Dimension(minWidth += ins.left + ins.right, minHeight);
    }

    static enum Type {
        LINE_COLUMN,
        TYPING_MODE;

    }
}

