/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.hints.pom.Bundle;
import org.netbeans.modules.maven.hints.pom.JavaNetRepositoryErrorCustomizer;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.modules.maven.model.pom.RepositoryContainer;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.Line;

public class JavaNetRepositoryError
implements POMErrorFixProvider {
    static final String PROP_SELECTED = "selectedOnly";
    static final String PROP_URLS = "urls";
    static final String DEFAULT_URLS = "http://download.java.net/maven/2/ http://download.java.net/maven/1/ ";
    private static final Logger LOG = Logger.getLogger(JavaNetRepositoryError.class.getName());
    private final Configuration configuration = new Configuration("JavaNetRepositoryError", Bundle.TIT_JavaNetRepositoryError(), Bundle.DESC_JavaNetRepositoryError(), true, Configuration.HintSeverity.WARNING);
    private JComponent component;

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj) {
        assert (model != null);
        ArrayList<ErrorDescription> toRet = new ArrayList<ErrorDescription>();
        if (prj == null) {
            return toRet;
        }
        this.checkRepositoryList(model.getProject().getRepositories(), model, (RepositoryContainer)model.getProject(), false, toRet);
        this.checkRepositoryList(model.getProject().getPluginRepositories(), model, (RepositoryContainer)model.getProject(), true, toRet);
        List profiles = model.getProject().getProfiles();
        if (profiles != null) {
            for (Profile prof : profiles) {
                this.checkRepositoryList(prof.getRepositories(), model, (RepositoryContainer)prof, false, toRet);
                this.checkRepositoryList(prof.getPluginRepositories(), model, (RepositoryContainer)prof, true, toRet);
            }
        }
        return toRet;
    }

    private void checkRepositoryList(List<Repository> repositories, POMModel model, RepositoryContainer container, boolean isPlugin, List<ErrorDescription> toRet) {
        if (repositories != null) {
            boolean justSelected = this.configuration.getPreferences().getBoolean(PROP_SELECTED, true);
            Set<String> forbidden = this.getForbidden();
            for (Repository rep : repositories) {
                Object url = rep.getUrl();
                if (url == null) continue;
                if (!((String)url).endsWith("/")) {
                    url = (String)url + "/";
                }
                if (justSelected && !forbidden.contains(url)) continue;
                int position = rep.findChildElementPosition(model.getPOMQNames().URL.getQName());
                try {
                    Line line = NbEditorUtilities.getLine((Document)model.getBaseDocument(), (int)position, (boolean)false);
                    OverrideFix basefix = new OverrideFix(rep, container, isPlugin);
                    toRet.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.configuration.getSeverity(this.configuration.getPreferences()).toEditorSeverity(), (String)Bundle.TXT_UsesJavanetRepository(), Collections.singletonList(ErrorDescriptionFactory.attachSubfixes((Fix)basefix, Collections.singletonList(new Configure(this.configuration)))), (Document)model.getBaseDocument(), (int)(line.getLineNumber() + 1)));
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.log(Level.INFO, "wrong repository pos in model for : " + (String)url, e);
                }
            }
        }
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        if (this.component == null) {
            this.component = new JavaNetRepositoryErrorCustomizer(preferences);
        }
        return this.component;
    }

    @Override
    public String getSavedValue(JComponent customCustomizer, String key) {
        return ((JavaNetRepositoryErrorCustomizer)customCustomizer).getSavedValue(key);
    }

    @Override
    public void cancel() {
        this.component = null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> getForbidden() {
        String urls = this.configuration.getPreferences().get(PROP_URLS, DEFAULT_URLS);
        HashSet<String> toRet = new HashSet<String>();
        for (String string : urls.split("([\\s])+")) {
            void var6_6;
            String string2 = string.trim();
            if (!string2.endsWith("/")) {
                String string3 = string2 + "/";
            }
            toRet.add((String)var6_6);
        }
        return toRet;
    }

    private static class OverrideFix
    implements Fix,
    Runnable {
        private final Repository repository;
        private final RepositoryContainer container;
        private final boolean pluginRepo;

        OverrideFix(Repository plg, RepositoryContainer container, boolean isPlugin) {
            this.repository = plg;
            this.container = container;
            this.pluginRepo = isPlugin;
        }

        public String getText() {
            return Bundle.TEXT_UseJavanetRepository();
        }

        @Override
        public void run() {
            if (this.pluginRepo) {
                this.container.removePluginRepository(this.repository);
            } else {
                this.container.removeRepository(this.repository);
            }
        }

        public ChangeInfo implement() throws Exception {
            ChangeInfo info = new ChangeInfo();
            POMModel mdl = this.repository.getModel();
            if (!mdl.getState().equals((Object)Model.State.VALID)) {
                return info;
            }
            PomModelUtils.implementInTransaction((Model)mdl, this);
            return info;
        }
    }

    private static class Configure
    implements Fix {
        private final Configuration config;

        Configure(Configuration configuration) {
            this.config = configuration;
        }

        public String getText() {
            return Bundle.TXT_Configure(this.config.getDisplayName());
        }

        public ChangeInfo implement() throws Exception {
            OptionsDisplayer.getDefault().open("Editor/Hints/text/x-maven-pom+xml/" + this.config.getId());
            return new ChangeInfo();
        }
    }
}

