/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jshell.agent;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import jdk.jshell.spi.SPIResolutionException;
import org.netbeans.lib.jshell.agent.RemoteClassLoader;

class RemoteAgent {
    protected RemoteClassLoader loader = new RemoteClassLoader();
    private final Map<String, Class<?>> klasses = new TreeMap();
    private boolean inClientCode;
    private boolean expectingStop;
    private final StopExecutionException stopException = new StopExecutionException();

    RemoteAgent() {
    }

    public static void main(String[] args) throws Exception {
        String loopBack = null;
        Socket socket = new Socket(loopBack, Integer.parseInt(args[0]));
        new RemoteAgent().commandLoop(socket);
    }

    void commandLoop(Socket socket) throws IOException {
        ObjectInputStream in = new ObjectInputStream(socket.getInputStream());
        OutputStream socketOut = socket.getOutputStream();
        System.setOut(new PrintStream(new MultiplexingOutputStream("out", socketOut), true));
        System.setErr(new PrintStream(new MultiplexingOutputStream("err", socketOut), true));
        ObjectOutputStream out = new ObjectOutputStream(new MultiplexingOutputStream("command", socketOut));
        while (true) {
            int cmd = in.readInt();
            this.performCommand(cmd, in, out);
        }
    }

    protected void performCommand(int cmd, ObjectInputStream in, ObjectOutputStream out) throws IOException {
        switch (cmd) {
            case 0: {
                return;
            }
            case 1: {
                try {
                    int count = in.readInt();
                    ArrayList<String> names = new ArrayList<String>(count);
                    for (int i = 0; i < count; ++i) {
                        String name = in.readUTF();
                        byte[] kb = (byte[])in.readObject();
                        this.loader.delare(name, kb);
                        names.add(name);
                    }
                    for (String name : names) {
                        Class<?> klass = this.loader.loadClass(name);
                        this.klasses.put(name, klass);
                        klass.getDeclaredMethods();
                    }
                    out.writeInt(100);
                    out.flush();
                }
                catch (IOException ex) {
                    this.handleLoadFailure(ex, out);
                }
                catch (ClassNotFoundException ex) {
                    this.handleLoadFailure(ex, out);
                }
                catch (ClassCastException ex) {
                    this.handleLoadFailure(ex, out);
                }
                break;
            }
            case 3: {
                String name = in.readUTF();
                Class<?> klass = this.klasses.get(name);
                if (klass == null) {
                    this.debug("*** Invoke failure: no such class loaded %s\n", name);
                    out.writeInt(101);
                    out.writeUTF("no such class loaded: " + name);
                    out.flush();
                    break;
                }
                String methodName = in.readUTF();
                try {
                    Object res;
                    Method doitMethod = klass.getDeclaredMethod(methodName, new Class[0]);
                    doitMethod.setAccessible(true);
                    try {
                        this.clientCodeEnter();
                        res = doitMethod.invoke(null, new Object[0]);
                    }
                    catch (InvocationTargetException ex) {
                        if (ex.getCause() instanceof ThreadDeath) {
                            this.expectingStop = false;
                            throw (ThreadDeath)ex.getCause();
                        }
                        throw ex;
                    }
                    catch (StopExecutionException ex) {
                        this.expectingStop = false;
                        throw ex;
                    }
                    finally {
                        this.clientCodeLeave();
                    }
                    out.writeInt(100);
                    out.writeUTF(RemoteAgent.valueString(res));
                    out.flush();
                }
                catch (InvocationTargetException ex) {
                    Throwable cause = ex.getCause();
                    StackTraceElement[] elems = cause.getStackTrace();
                    if (cause instanceof SPIResolutionException) {
                        out.writeInt(103);
                        out.writeInt(((SPIResolutionException)cause).id());
                    } else {
                        out.writeInt(102);
                        out.writeUTF(cause.getClass().getName());
                        out.writeUTF(cause.getMessage() == null ? "<none>" : cause.getMessage());
                    }
                    out.writeInt(elems.length);
                    for (StackTraceElement ste : elems) {
                        out.writeUTF(ste.getClassName());
                        out.writeUTF(ste.getMethodName());
                        out.writeUTF(ste.getFileName() == null ? "<none>" : ste.getFileName());
                        out.writeInt(ste.getLineNumber());
                    }
                    out.flush();
                }
                catch (NoSuchMethodException ex) {
                    this.handleInvocationFailure(ex, out);
                }
                catch (IllegalAccessException ex) {
                    this.handleInvocationFailure(ex, out);
                }
                catch (StopExecutionException ex) {
                    try {
                        out.writeInt(104);
                        out.flush();
                    }
                    catch (IOException err) {
                        this.debug("*** Error writing killed result: %s -- %s\n", ex, ex.getCause());
                    }
                }
                System.out.flush();
                break;
            }
            case 5: {
                String classname = in.readUTF();
                String varname = in.readUTF();
                Class<?> klass = this.klasses.get(classname);
                if (klass == null) {
                    this.debug("*** Var value failure: no such class loaded %s\n", classname);
                    out.writeInt(101);
                    out.writeUTF("no such class loaded: " + classname);
                    out.flush();
                    break;
                }
                try {
                    Field var = klass.getDeclaredField(varname);
                    var.setAccessible(true);
                    Object res = var.get(null);
                    out.writeInt(100);
                    out.writeUTF(RemoteAgent.valueString(res));
                    out.flush();
                }
                catch (Exception ex) {
                    this.debug("*** Var value failure: no such field %s.%s\n", classname, varname);
                    out.writeInt(101);
                    out.writeUTF("no such field loaded: " + varname + " in class: " + classname);
                    out.flush();
                }
                break;
            }
            case 4: {
                String cp = in.readUTF();
                for (String path : cp.split(File.pathSeparator)) {
                    this.loader.addURL(new File(path).toURI().toURL());
                }
                out.writeInt(100);
                out.flush();
                break;
            }
            default: {
                this.debug("*** Bad command code: %d\n", cmd);
            }
        }
    }

    private void handleLoadFailure(Throwable ex, ObjectOutputStream out) throws IOException {
        this.debug("*** Load failure: %s\n", ex);
        out.writeInt(101);
        out.writeUTF(ex.toString());
        out.flush();
    }

    private void handleInvocationFailure(Throwable ex, ObjectOutputStream out) throws IOException {
        this.debug("*** Invoke failure: %s -- %s\n", ex, ex.getCause());
        out.writeInt(101);
        out.writeUTF(ex.toString());
        out.flush();
    }

    protected void handleUnknownCommand(int cmd, ObjectInputStream i, ObjectOutputStream o) throws IOException {
        this.debug("*** Bad command code: %d\n", cmd);
    }

    void clientCodeEnter() {
        this.expectingStop = false;
        this.inClientCode = true;
    }

    void clientCodeLeave() {
        this.inClientCode = false;
        while (this.expectingStop) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException ex) {
                this.debug("*** Sleep interrupted while waiting for stop exception: %s\n", ex);
            }
        }
    }

    private void debug(String format, Object ... args) {
        System.err.printf("REMOTE: " + format, args);
    }

    static String valueString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + (String)value + "\"";
        }
        if (value instanceof Character) {
            return "'" + value + "'";
        }
        return value.toString();
    }

    private class StopExecutionException
    extends ThreadDeath {
        private StopExecutionException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class MultiplexingOutputStream
    extends OutputStream {
        private static final int PACKET_SIZE = 127;
        private final byte[] name;
        private final OutputStream delegate;

        public MultiplexingOutputStream(String name, OutputStream delegate) {
            this.name = name.getBytes(StandardCharsets.UTF_8);
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            OutputStream outputStream = this.delegate;
            synchronized (outputStream) {
                this.delegate.write(this.name.length);
                this.delegate.write(this.name);
                this.delegate.write(1);
                this.delegate.write(b);
                this.delegate.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputStream outputStream = this.delegate;
            synchronized (outputStream) {
                int i = 0;
                while (len > 0) {
                    int size = Math.min(127, len);
                    this.delegate.write(this.name.length);
                    this.delegate.write(this.name);
                    this.delegate.write(size);
                    this.delegate.write(b, off + i, size);
                    i += size;
                    len -= size;
                }
                this.delegate.flush();
            }
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.delegate.close();
        }
    }
}

