/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jshell.agent;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.netbeans.lib.jshell.agent.RemoteClassLoader;

class NbRemoteLoader
extends RemoteClassLoader {
    private final NbRemoteLoader oldDelegate;
    private final Map<String, Long> classIds;
    private final Map<String, Class> namedClasses;
    private final Map<Long, Class> definedClasses;

    public NbRemoteLoader(ClassLoader parent, ClassLoader oldDelegate, URL[] additionalURLs) {
        super(additionalURLs);
        if (oldDelegate != null && !(oldDelegate instanceof NbRemoteLoader)) {
            throw new IllegalArgumentException("Invalid classloader: " + oldDelegate);
        }
        this.oldDelegate = (NbRemoteLoader)oldDelegate;
        if (oldDelegate == null) {
            this.classIds = new HashMap<String, Long>();
            this.definedClasses = new HashMap<Long, Class>();
            this.namedClasses = new HashMap<String, Class>();
        } else {
            this.classIds = this.oldDelegate.classIds;
            this.definedClasses = this.oldDelegate.definedClasses;
            this.namedClasses = this.oldDelegate.namedClasses;
        }
    }

    private Class registerClass(Class c) {
        Long ret = (long)this.classIds.size() + 1L;
        String className = c.getName();
        this.classIds.put(className, ret);
        this.definedClasses.put(ret, c);
        this.namedClasses.put(className, c);
        return c;
    }

    Long getClassId(String className) {
        return this.classIds.get(className);
    }

    Class getClassOfId(Long id) {
        if (id == null) {
            return null;
        }
        return this.definedClasses.get(id);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            Class<?> c = this.getParent().loadClass(name);
            return c;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> c;
            if (this.oldDelegate != null) {
                try {
                    Class<?> c2 = this.oldDelegate.findClass(name);
                    return this.registerClass(c2);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            if ((c = this.namedClasses.get(name)) != null) {
                return c;
            }
            c = super.findClass(name);
            return this.registerClass(c);
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> origResources = this.getParent().getResources(name);
        Enumeration deleResources = this.oldDelegate != null ? this.oldDelegate.findResources(name) : Collections.emptyEnumeration();
        return new CompoundEnumeration<URL>(new Enumeration[]{origResources, deleResources, super.findResources(name)});
    }

    @Override
    public URL findResource(String name) {
        try {
            Enumeration<URL> res = this.findResources(name);
            return res.hasMoreElements() ? res.nextElement() : null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static class CompoundEnumeration<T>
    implements Enumeration<T> {
        private final Enumeration<T>[] enums;
        private final HashSet<T> enumerated = new HashSet();
        private int index;
        private T nextItem;

        public CompoundEnumeration(Enumeration<T>[] enums) {
            this.enums = enums;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.nextItem != null) {
                return true;
            }
            while (this.index < this.enums.length) {
                Enumeration<T> del = this.enums[this.index];
                if (del.hasMoreElements()) {
                    T item = del.nextElement();
                    if (!this.enumerated.add(item)) continue;
                    this.nextItem = item;
                    break;
                }
                ++this.index;
            }
            return this.nextItem != null;
        }

        @Override
        public T nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.nextItem;
        }
    }
}

