/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.Module;
import org.netbeans.api.project.Project;
import org.netbeans.core.startup.Main;
import org.netbeans.modules.ide.ergonomics.fod.ConfigurationPanel;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureProjectFactory;
import org.netbeans.modules.ide.ergonomics.fod.FoDLayersProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class FeatureManager
implements PropertyChangeListener,
LookupListener {
    private static FeatureManager INSTANCE;
    private static final Logger UILOG;
    private static final RequestProcessor RP;
    private final Lookup.Result<ModuleInfo> result;
    private final ChangeSupport support;
    private Set<String> enabledCnbs = Collections.emptySet();
    private static Lookup featureTypesLookup;
    private static boolean noCnbCheck;
    private static final Logger LOG;

    private FeatureManager() {
        this.support = new ChangeSupport((Object)this);
        this.result = Lookup.getDefault().lookupResult(ModuleInfo.class);
        this.result.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public static synchronized FeatureManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FeatureManager();
        }
        return INSTANCE;
    }

    public RequestProcessor.Task create(Runnable r) {
        return RP.create(r);
    }

    public RequestProcessor.Task create(Runnable r, boolean finished) {
        return RP.create(r, finished);
    }

    static void logUI(String msg, Object ... params) {
        LogRecord rec = new LogRecord(Level.FINE, msg);
        rec.setResourceBundleName("org.netbeans.modules.ide.ergonomics.fod.Bundle");
        rec.setResourceBundle(NbBundle.getBundle(ConfigurationPanel.class));
        rec.setParameters(params);
        rec.setLoggerName(UILOG.getName());
        UILOG.log(rec);
    }

    static boolean showInAU(ModuleInfo mi) {
        return Main.getModuleSystem().isShowInAutoUpdateClient(mi);
    }

    public static Map<String, String> nbprojectTypes() {
        return FeatureInfo.nbprojectTypes();
    }

    public static Map<String, String> projectFiles() {
        return FeatureInfo.projectFiles();
    }

    public static Collection<? extends FeatureInfo> features() {
        return FeatureManager.featureTypesLookup().lookupAll(FeatureInfo.class);
    }

    static FeatureInfo findInfo(String cnb) {
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            if (!featureInfo.getCodeNames().contains(cnb)) continue;
            return featureInfo;
        }
        return null;
    }

    public static int dumpModules() {
        return FeatureManager.dumpModules(Level.FINE, Level.FINEST);
    }

    public static int dumpModules(Level withLevel, Level detailsLevel) {
        if (!FoDLayersProvider.LOG.isLoggable(withLevel)) {
            return -1;
        }
        int cnt = 0;
        Collection allModules = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            TreeSet<String> enabled = new TreeSet<String>();
            TreeSet<String> disabled = new TreeSet<String>();
            for (ModuleInfo m : allModules) {
                if (!featureInfo.getCodeNames().contains(m.getCodeNameBase())) continue;
                if (m.isEnabled()) {
                    enabled.add(m.getCodeNameBase());
                    continue;
                }
                disabled.add(m.getCodeNameBase());
            }
            if (enabled.isEmpty() && disabled.isEmpty()) {
                FoDLayersProvider.LOG.log(withLevel, featureInfo.clusterName + " not present");
                continue;
            }
            if (enabled.isEmpty()) {
                FoDLayersProvider.LOG.log(withLevel, featureInfo.clusterName + " disabled");
                continue;
            }
            if (disabled.isEmpty()) {
                FoDLayersProvider.LOG.log(withLevel, featureInfo.clusterName + " enabled");
                ++cnt;
                continue;
            }
            FoDLayersProvider.LOG.log(withLevel, featureInfo.clusterName + " enabled " + enabled.size() + " disabled " + disabled.size());
            ++cnt;
            for (String cnb : disabled) {
                FoDLayersProvider.LOG.log(detailsLevel, "- " + cnb);
            }
            for (String cnb : enabled) {
                FoDLayersProvider.LOG.log(detailsLevel, "+ " + cnb);
            }
        }
        return cnt;
    }

    public static synchronized void assignFeatureTypesLookup(Lookup lkp) {
        boolean eaOn = false;
        if (!$assertionsDisabled) {
            eaOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!eaOn) {
            throw new IllegalStateException();
        }
        featureTypesLookup = lkp;
        noCnbCheck = true;
    }

    private static synchronized Lookup featureTypesLookup() {
        if (featureTypesLookup != null) {
            return featureTypesLookup;
        }
        String clusters = System.getProperty("netbeans.dirs");
        if (clusters == null) {
            featureTypesLookup = Lookup.EMPTY;
        } else {
            String[] paths;
            InstanceContent ic = new InstanceContent();
            AbstractLookup l = new AbstractLookup((AbstractLookup.Content)ic);
            for (String c : paths = clusters.split(File.pathSeparator)) {
                int last = c.lastIndexOf(File.separatorChar);
                String clusterName = c.substring(last + 1).replaceFirst("[0-9\\.]*$", "");
                String basename = "/org/netbeans/modules/ide/ergonomics/" + clusterName;
                String layerName = basename + "/layer.xml";
                String bundleName = basename + "/Bundle.properties";
                URL layer = FeatureManager.class.getResource(layerName);
                URL bundle = FeatureManager.class.getResource(bundleName);
                if (layer == null || bundle == null) continue;
                try {
                    FeatureInfo info = FeatureInfo.create(clusterName, layer, bundle);
                    ic.add((Object)info);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            featureTypesLookup = l;
        }
        return featureTypesLookup;
    }

    public void addChangeListener(ChangeListener l) {
        this.support.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.support.removeChangeListener(l);
    }

    public void resultChanged(LookupEvent ev) {
        for (ModuleInfo m : this.result.allInstances()) {
            m.removePropertyChangeListener((PropertyChangeListener)this);
            m.addPropertyChangeListener((PropertyChangeListener)this);
        }
        HashSet<String> tmp = new HashSet<String>();
        for (ModuleInfo mi : this.result.allInstances()) {
            if (!mi.isEnabled()) continue;
            tmp.add(mi.getCodeNameBase());
        }
        this.enabledCnbs = tmp;
        if (ev != null) {
            this.fireChange();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            ModuleInfo mi = (ModuleInfo)evt.getSource();
            if (!noCnbCheck && this.enabledCnbs.contains(mi.getCodeNameBase()) && mi.isEnabled()) {
                return;
            }
            this.fireChange();
            if (mi.isEnabled()) {
                this.enabledCnbs.add(mi.getCodeNameBase());
            } else {
                this.enabledCnbs.remove(mi.getCodeNameBase());
            }
        }
    }

    private void fireChange() {
        FoDLayersProvider.LOG.fine("Firing FeatureManager change");
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            featureInfo.clearCache();
        }
        this.support.fireChange();
        FoDLayersProvider.LOG.fine("FeatureManager change delivered");
    }

    public final void waitFinished() {
        RP.post(new Runnable(){

            @Override
            public void run() {
            }
        }).waitFinished();
    }

    static void associateFiles(List<FileObject> enabled) {
        long when = 0L;
        for (FileObject f : enabled) {
            long t = f.lastModified().getTime();
            if (t <= when) continue;
            when = t;
        }
        for (FileObject f : enabled) {
            LOG.log(Level.FINE, "Enabling ErgoControl for {0}", f);
            try {
                f.setAttribute("ergonomicsEnabled", (Object)when);
                f.setAttribute("ergonomicsUnused", (Object)0);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void incrementUnused(Project[] projects) throws IOException {
        FileObject fo = FileUtil.getConfigFile((String)"Modules");
        if (fo == null) {
            return;
        }
        FileObject[] arr = fo.getChildren();
        HashSet<String> enabled = new HashSet<String>();
        for (ModuleInfo mi : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            Module m = (Module)mi;
            if (m.isAutoload() || m.isEager() || m.isFixed() || !m.isEnabled()) continue;
            enabled.add(m.getCodeNameBase());
        }
        HashMap<String, Long> cnb2Date = new HashMap<String, Long>();
        HashMap<Long, List<FileObject>> date2Files = new HashMap<Long, List<FileObject>>();
        HashSet<String> explicitlyUsedCnbs = new HashSet<String>();
        for (int i = 0; i < arr.length; ++i) {
            void var12_20;
            FileObject module = arr[i];
            String cnb = module.getName().replace('-', '.');
            Object object = module.getAttribute("ergonomicsEnabled");
            LOG.log(Level.FINEST, "Controlling {0}: {1}", new Object[]{module, object});
            if (!(object instanceof Long) || (Long)object < module.lastModified().getTime()) {
                if (!enabled.contains(cnb)) continue;
                explicitlyUsedCnbs.add(cnb);
                continue;
            }
            Long date = (Long)object;
            cnb2Date.put(cnb, date);
            List list = (List)date2Files.get(date);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                date2Files.put(date, arrayList);
            }
            var12_20.add(module);
        }
        Set<String> transitivelyUsedCnbs = FeatureManager.transitiveDeps(explicitlyUsedCnbs);
        ArrayList<FeatureInfo> unused = new ArrayList<FeatureInfo>();
        block4: for (FeatureInfo featureInfo : FeatureManager.features()) {
            for (ModuleInfo moduleInfo : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
                if (!FeatureManager.isModuleFrom(moduleInfo, featureInfo.clusterName) || !transitivelyUsedCnbs.contains(moduleInfo.getCodeNameBase())) continue;
                LOG.log(Level.FINE, "Transitive dependency on {0}", moduleInfo.getCodeNameBase());
                FeatureManager.markUsed(unused, featureInfo, cnb2Date, date2Files);
                continue block4;
            }
            unused.add(featureInfo);
        }
        for (int i = 0; i < projects.length; ++i) {
            FeatureProjectFactory.Data data = new FeatureProjectFactory.Data(projects[i].getProjectDirectory(), true);
            for (FeatureInfo featureInfo : FeatureManager.features()) {
                if (!featureInfo.isEnabled()) continue;
                if (featureInfo.isProject(data) == 0) {
                    boolean markedProject = false;
                    try {
                        String markerClass = featureInfo.getExtraProjectMarkerClass();
                        if (markerClass != null) {
                            Class<?> testClass = projects[i].getClass().getClassLoader().loadClass(markerClass);
                            markedProject |= projects[i].getLookup().lookup(testClass) != null;
                        }
                    }
                    catch (ClassNotFoundException markerClass) {
                        // empty catch block
                    }
                    if (!markedProject) continue;
                }
                FeatureManager.markUsed(unused, featureInfo, cnb2Date, date2Files);
            }
        }
        HashSet<FileObject> processed = new HashSet<FileObject>();
        for (FeatureInfo fi : unused) {
            void var12_32;
            LOG.log(Level.FINE, "Unused feature {0}", fi.clusterName);
            Object var12_28 = null;
            for (String cnb : fi.getCodeNames()) {
                Long l;
                void var12_29;
                if (var12_29 == null && (l = (Long)cnb2Date.get(cnb)) == null) break;
                if (var12_29.equals(cnb2Date.get(cnb))) continue;
                date2Files.remove(var12_29);
                Object var12_31 = null;
                break;
            }
            if (var12_32 == null) continue;
            for (List list : date2Files.values()) {
                for (FileObject increment : list) {
                    if (!processed.add(increment)) continue;
                    int now = 0;
                    Object obj = increment.getAttribute("ergonomicsUnused");
                    if (obj instanceof Number) {
                        now = ((Number)obj).intValue();
                    }
                    increment.setAttribute("ergonomicsUnused", (Object)(++now));
                    LOG.log(Level.FINE, "Incremented to {0} for {1}", new Object[]{now, increment});
                }
            }
        }
    }

    public static void disableUnused(int howMuch) throws Exception {
        FileObject fo = FileUtil.getConfigFile((String)"Modules");
        FileObject[] arr = fo.getChildren();
        boolean first = true;
        for (int i = 0; i < arr.length; ++i) {
            FileObject module = arr[i];
            Object when = module.getAttribute("ergonomicsEnabled");
            LOG.log(Level.FINEST, "Checking {0}: {1}", new Object[]{module, when});
            if (!(when instanceof Long) || (Long)when < module.lastModified().getTime()) continue;
            Object unused = module.getAttribute("ergonomicsUnused");
            LOG.log(Level.FINEST, "Unused {0}", unused);
            if (!(unused instanceof Number) || ((Number)unused).intValue() < howMuch) continue;
            String cnb = module.getName().replace('-', '.');
            if (first) {
                LOG.info("Long time unused modules found, disabling:");
                first = false;
            }
            LOG.info(cnb);
            module.revert();
        }
    }

    private static Set<String> transitiveDeps(Set<String> cnbs) {
        int prev;
        HashSet<String> all = new HashSet<String>();
        all.addAll(cnbs);
        do {
            prev = all.size();
            for (ModuleInfo mi : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
                if (!all.contains(mi.getCodeNameBase())) continue;
                for (Dependency d : mi.getDependencies()) {
                    if (d.getType() != 1) continue;
                    String moduleName = d.getName();
                    int slash = moduleName.indexOf(47);
                    if (slash != -1) {
                        moduleName = moduleName.substring(0, slash);
                    }
                    all.add(moduleName);
                }
            }
        } while (prev != all.size());
        HashSet test = null;
        assert ((test = new HashSet(all)) != null);
        if (test != null) {
            for (ModuleInfo mi : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
                test.remove(mi.getCodeNameBase());
            }
            assert (test.isEmpty()) : "Only CNBs are in the set: " + test;
        }
        return all;
    }

    static boolean isModuleFrom(ModuleInfo mi, String prefix) {
        if (!(mi instanceof Module)) {
            return false;
        }
        File f = ((Module)mi).getJarFile();
        return f != null && f.getParentFile().getName().equals("modules") && f.getParentFile().getParentFile().getName().startsWith(prefix);
    }

    private static void markUsed(List<FeatureInfo> unused, FeatureInfo fi, Map<String, Long> cnb2Date, Map<Long, List<FileObject>> date2Files) throws IOException {
        unused.remove(fi);
        for (String cnb : fi.getCodeNames()) {
            Long thisIsUsedGroup = cnb2Date.get(cnb);
            List<FileObject> files = date2Files.get(thisIsUsedGroup);
            if (files == null) continue;
            for (FileObject usedFile : files) {
                Object prev = usedFile.getAttribute("ergonomicsUnused");
                if (!(prev instanceof Number) || ((Number)prev).intValue() == 0) {
                    LOG.log(Level.FINE, "Already marked as used: {0}", usedFile);
                    continue;
                }
                LOG.log(Level.FINE, "Marking {0} as used", usedFile);
                usedFile.setAttribute("ergonomicsUnused", (Object)0);
            }
            date2Files.remove(thisIsUsedGroup);
        }
    }

    static {
        UILOG = Logger.getLogger("org.netbeans.ui.ergonomics");
        RP = new RequestProcessor("FoD Processor");
        LOG = Logger.getLogger(FeatureManager.class.getName());
    }
}

