/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVirtualNodePoolRequest
extends BmcRequest<Void> {
    private String virtualNodePoolId;
    private String opcRequestId;

    public String getVirtualNodePoolId() {
        return this.virtualNodePoolId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().virtualNodePoolId(this.virtualNodePoolId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",virtualNodePoolId=").append(String.valueOf(this.virtualNodePoolId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVirtualNodePoolRequest)) {
            return false;
        }
        GetVirtualNodePoolRequest other = (GetVirtualNodePoolRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.virtualNodePoolId, other.virtualNodePoolId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.virtualNodePoolId == null ? 43 : this.virtualNodePoolId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVirtualNodePoolRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String virtualNodePoolId = null;
        private String opcRequestId = null;

        public Builder virtualNodePoolId(String virtualNodePoolId) {
            this.virtualNodePoolId = virtualNodePoolId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVirtualNodePoolRequest o) {
            this.virtualNodePoolId(o.getVirtualNodePoolId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVirtualNodePoolRequest build() {
            GetVirtualNodePoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVirtualNodePoolRequest buildWithoutInvocationCallback() {
            GetVirtualNodePoolRequest request = new GetVirtualNodePoolRequest();
            request.virtualNodePoolId = this.virtualNodePoolId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

