/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class StaticConstantAccess
extends StaticDispatch {
    private final Expression constant;
    private final boolean isDynamicName;

    public StaticConstantAccess(int start, int end, Expression className, Expression constant, boolean isDynamicName) {
        super(start, end, className);
        this.constant = constant;
        this.isDynamicName = isDynamicName;
    }

    public StaticConstantAccess(int start, int end, Expression className, Expression constant) {
        this(start, end, className, constant, false);
    }

    public StaticConstantAccess(int start, int end, Identifier name) {
        this(start, end, null, name);
    }

    public Expression getConstant() {
        return this.constant;
    }

    public Identifier getConstantName() {
        Expression expression = this.constant;
        while (expression instanceof ExpressionArrayAccess) {
            expression = ((ExpressionArrayAccess)expression).getExpression();
        }
        assert (expression != null);
        if (this.isDynamicName) {
            if (expression instanceof ReflectionVariable) {
                expression = ((ReflectionVariable)expression).getName();
            }
            expression = new Identifier(this.constant.getStartOffset(), this.constant.getEndOffset(), "{" + expression.toString() + "}");
        }
        assert (expression instanceof Identifier) : "Expected Identifier but got: " + expression.getClass().getName();
        return (Identifier)expression;
    }

    public boolean isDynamicName() {
        return this.isDynamicName;
    }

    @Override
    public ASTNode getMember() {
        return this.getConstant();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

