/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.EnumElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TraitElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.CaseElement;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.EnumScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.ClassConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.InterfaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.LazyBuild;
import org.netbeans.modules.php.editor.model.impl.MethodScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TraitScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TypeScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.EnumDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;

class EnumScopeImpl
extends TypeScopeImpl
implements EnumScope,
VariableNameFactory {
    private final Collection<QualifiedName> usedTraits = new HashSet<QualifiedName>();
    private final QualifiedName backingType;

    EnumScopeImpl(Scope inScope, EnumDeclarationInfo nodeInfo, boolean isDeprecated) {
        super(inScope, nodeInfo, isDeprecated);
        for (QualifiedName usedTrait : nodeInfo.getUsedTraits()) {
            this.usedTraits.add(VariousUtils.getFullyQualifiedName(usedTrait, ((EnumDeclaration)nodeInfo.getOriginalNode()).getStartOffset(), inScope));
        }
        this.backingType = nodeInfo.getBackingType();
    }

    EnumScopeImpl(IndexScope inScope, EnumElement indexedEnum) {
        super((Scope)inScope, indexedEnum);
        this.usedTraits.addAll(indexedEnum.getUsedTraits());
        this.backingType = indexedEnum.getBackingType();
    }

    @Override
    @CheckForNull
    public QualifiedName getBackingType() {
        return this.backingType;
    }

    @NonNull
    private String getBackingTypeName() {
        return this.backingType == null ? "" : this.backingType.toString();
    }

    @Override
    void addElement(ModelElementImpl element) {
        assert (element instanceof TypeScope || element instanceof VariableName || element instanceof MethodScope || element instanceof FieldElement || element instanceof ClassConstantElement || element instanceof CaseElement) : element.getPhpElementKind();
        if (element instanceof TypeScope) {
            Scope inScope = this.getInScope();
            if (inScope instanceof ScopeImpl) {
                ((ScopeImpl)inScope).addElement(element);
            }
        } else {
            super.addElement(element);
        }
    }

    @Override
    public String asString(TypeElement.PrintAs as) {
        StringBuilder retval = new StringBuilder();
        switch (as) {
            case NameAndSuperTypes: {
                retval.append(this.getName());
                this.printAsSuperTypes(retval);
                break;
            }
            case SuperTypes: {
                this.printAsSuperTypes(retval);
                break;
            }
            default: {
                assert (false) : as;
                break;
            }
        }
        return retval.toString();
    }

    private void printAsSuperTypes(StringBuilder sb) {
        Set<QualifiedName> superIfaces = this.getSuperInterfaces();
        if (!superIfaces.isEmpty()) {
            sb.append(" implements ");
        }
        StringBuilder ifacesBuffer = new StringBuilder();
        for (QualifiedName qualifiedName : superIfaces) {
            if (ifacesBuffer.length() > 0) {
                ifacesBuffer.append(", ");
            }
            ifacesBuffer.append(qualifiedName.getName());
        }
        sb.append((CharSequence)ifacesBuffer);
    }

    @Override
    public Collection<? extends MethodScope> getInheritedMethods() {
        TypeElement type;
        HashSet<MethodScopeImpl> allMethods = new HashSet<MethodScopeImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        ElementQuery.Index index = indexScope.getIndex();
        HashSet interfaceScopes = new HashSet(this.getSuperInterfaceScopes());
        for (InterfaceScope iface : interfaceScopes) {
            Set<MethodElement> set = ElementFilter.forPrivateModifiers(false).filter(index.getAllMethods(iface));
            for (MethodElement classMember : set) {
                MethodElement indexedFunction = classMember;
                type = indexedFunction.getType();
                if (type.isInterface()) {
                    allMethods.add(new MethodScopeImpl((Scope)new InterfaceScopeImpl(indexScope, (InterfaceElement)type), indexedFunction));
                    continue;
                }
                allMethods.add(new MethodScopeImpl((Scope)new EnumScopeImpl(indexScope, (EnumElement)type), indexedFunction));
            }
        }
        HashSet<? extends TraitScope> traitScopes = new HashSet<TraitScope>(this.getTraits());
        for (TraitScope traitScope : traitScopes) {
            Set<MethodElement> indexedMethods = index.getAllMethods(traitScope);
            for (MethodElement methodElement : indexedMethods) {
                type = methodElement.getType();
                if (type.isTrait()) {
                    allMethods.add(new MethodScopeImpl((Scope)new TraitScopeImpl((Scope)indexScope, (TraitElement)type), methodElement));
                    continue;
                }
                allMethods.add(new MethodScopeImpl((Scope)new EnumScopeImpl(indexScope, (EnumElement)type), methodElement));
            }
        }
        return allMethods;
    }

    @Override
    public final Collection<? extends ClassConstantElement> getInheritedConstants() {
        HashSet<ClassConstantElementImpl> allConstants = new HashSet<ClassConstantElementImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        ElementQuery.Index index = indexScope.getIndex();
        ElementFilter filterForPrivate = ElementFilter.forPrivateModifiers(false);
        HashSet interfaceScopes = new HashSet();
        interfaceScopes.addAll(this.getSuperInterfaceScopes());
        for (InterfaceScope iface : interfaceScopes) {
            Set<TypeConstantElement> indexedConstants = filterForPrivate.filter(index.getInheritedTypeConstants(iface));
            Iterator iterator = indexedConstants.iterator();
            while (iterator.hasNext()) {
                TypeConstantElement classMember;
                TypeConstantElement constant = classMember = (TypeConstantElement)iterator.next();
                allConstants.add(new ClassConstantElementImpl(iface, constant));
            }
        }
        return allConstants;
    }

    @Override
    public Collection<? extends MethodScope> getMethods() {
        HashSet<MethodScope> allMethods = new HashSet<MethodScope>();
        allMethods.addAll(this.getDeclaredMethods());
        allMethods.addAll(this.getInheritedMethods());
        return allMethods;
    }

    @Override
    public void addSelfToIndex(IndexDocument indexDocument) {
        String namespaceName;
        String name;
        indexDocument.addPair("enum", this.getIndexSignature(), true, true);
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        Set<QualifiedName> superInterfaces = this.getSuperInterfaces();
        for (QualifiedName qualifiedName : superInterfaces) {
            name = qualifiedName.getName();
            namespaceName = VariousUtils.getFullyQualifiedName(qualifiedName, this.getOffset(), namespaceScope).getNamespaceName();
            indexDocument.addPair("superiface", String.format("%s;%s;%s", name.toLowerCase(), name, namespaceName), true, true);
        }
        for (QualifiedName qualifiedName : this.getUsedTraits()) {
            name = qualifiedName.getName();
            namespaceName = VariousUtils.getFullyQualifiedName(qualifiedName, this.getOffset(), namespaceScope).getNamespaceName();
            indexDocument.addPair("usedtrait", String.format("%s;%s;%s", name.toLowerCase(), name, namespaceName), true, true);
        }
        indexDocument.addPair("top", this.getName().toLowerCase(), true, true);
        for (MethodScope methodScope : this.getDeclaredMethods()) {
            LazyBuild lazyMethod;
            if (methodScope instanceof LazyBuild && !(lazyMethod = (LazyBuild)((Object)methodScope)).isScanned()) {
                lazyMethod.scan();
            }
            if (StringUtils.isEmpty((String)methodScope.getName())) continue;
            methodScope.addSelfToIndex(indexDocument);
        }
        for (ClassConstantElement classConstantElement : this.getDeclaredConstants()) {
            classConstantElement.addSelfToIndex(indexDocument);
        }
        for (CaseElement caseElement : this.getDeclaredEnumCases()) {
            caseElement.addSelfToIndex(indexDocument);
        }
    }

    @Override
    public final Collection<? extends CaseElement> getDeclaredEnumCases() {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScopeImpl indexScopeImpl = (IndexScopeImpl)ModelUtils.getIndexScope(this);
            return indexScopeImpl.findEnumCases(this);
        }
        return EnumScopeImpl.filter(this.getElements(), element -> element.getPhpElementKind() == PhpElementKind.ENUM_CASE);
    }

    @Override
    public String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(';');
        sb.append(this.getName()).append(';');
        sb.append(this.getOffset()).append(';');
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        QualifiedName qualifiedName = namespaceScope != null ? namespaceScope.getQualifiedName() : QualifiedName.create("");
        sb.append(qualifiedName.toString()).append(';');
        sb.append(this.getBackingTypeName()).append(';');
        Collection superInterfaceNames = this.getSuperInterfaceNames();
        StringBuilder ifaceSb = new StringBuilder();
        for (String iface : superInterfaceNames) {
            if (ifaceSb.length() > 0) {
                ifaceSb.append(",");
            }
            ifaceSb.append(iface);
        }
        sb.append((CharSequence)ifaceSb);
        if (ifaceSb.length() > 0) {
            sb.append("|");
            StringBuilder fqIfaceSb = new StringBuilder();
            Collection<QualifiedName> fQSuperInterfaceNames = this.getFQSuperInterfaceNames();
            for (QualifiedName fQSuperInterfaceName : fQSuperInterfaceNames) {
                if (fqIfaceSb.length() > 0) {
                    fqIfaceSb.append(",");
                }
                fqIfaceSb.append(fQSuperInterfaceName.toString());
            }
            sb.append((CharSequence)fqIfaceSb);
        }
        sb.append(';');
        sb.append(this.getPhpModifiers().toFlags()).append(';');
        if (!this.usedTraits.isEmpty()) {
            StringBuilder traitSb = new StringBuilder();
            for (QualifiedName usedTrait : this.usedTraits) {
                if (traitSb.length() > 0) {
                    traitSb.append(",");
                }
                traitSb.append(usedTrait.toString());
            }
            sb.append((CharSequence)traitSb);
        }
        sb.append(';');
        sb.append(this.isDeprecated() ? 1 : 0).append(';');
        sb.append(this.getFilenameUrl()).append(';');
        return sb.toString();
    }

    @Override
    public QualifiedName getNamespaceName() {
        if (this.indexedElement instanceof EnumElement) {
            EnumElement indexedEnum = (EnumElement)this.indexedElement;
            return indexedEnum.getNamespaceName();
        }
        return super.getNamespaceName();
    }

    @Override
    public Collection<? extends VariableName> getDeclaredVariables() {
        return EnumScopeImpl.filter(this.getElements(), element -> {
            LazyBuild scope;
            if (element instanceof MethodScope && ((MethodScope)element).isInitiator() && element instanceof LazyBuild && !(scope = (LazyBuild)((Object)element)).isScanned()) {
                scope.scan();
            }
            return element.getPhpElementKind() == PhpElementKind.VARIABLE;
        });
    }

    @Override
    public VariableNameImpl createElement(Variable node) {
        VariableNameImpl retval = new VariableNameImpl((Scope)this, node, false);
        this.addElement(retval);
        return retval;
    }

    @Override
    public Collection<QualifiedName> getUsedTraits() {
        return Collections.unmodifiableCollection(this.usedTraits);
    }

    @Override
    public Collection<? extends TraitScope> getTraits() {
        ArrayList<? extends TraitScope> result = new ArrayList<TraitScope>();
        for (QualifiedName qualifiedName : this.getUsedTraits()) {
            result.addAll(IndexScopeImpl.getTraits(qualifiedName, this));
        }
        return result;
    }

    @Override
    public boolean isSuperTypeOf(TypeScope subType) {
        return false;
    }

    @Override
    public boolean isSubTypeOf(TypeScope superType) {
        return false;
    }

    @Override
    public String toString() {
        Collection<? extends TraitScope> traits;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        Collection implementedInterfaces = this.getSuperInterfaceScopes();
        if (!implementedInterfaces.isEmpty()) {
            sb.append(" implements ");
            for (InterfaceScope interfaceScope : implementedInterfaces) {
                sb.append(interfaceScope.getName()).append(" ");
            }
        }
        if (!(traits = this.getTraits()).isEmpty()) {
            sb.append(" uses ");
            for (TraitScope traitScope : traits) {
                sb.append(traitScope.getName()).append(" ");
            }
        }
        return sb.toString();
    }
}

