/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import java.awt.Image;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.netbeans.modules.java.lsp.server.explorer.TreeViewProvider;
import org.netbeans.modules.java.lsp.server.explorer.api.NodeChangeType;
import org.netbeans.modules.java.lsp.server.explorer.api.ResourceData;
import org.openide.nodes.Node;

public interface TreeNodeRegistry {
    public int registerNode(Node var1, TreeViewProvider var2);

    public void unregisterNode(int var1, Node var2);

    public Node findNode(int var1);

    public TreeViewProvider providerOf(int var1);

    public ImageDataOrIndex imageOrIndex(Image var1);

    public ResourceData imageContents(URI var1);

    public CompletionStage<TreeViewProvider> createProvider(String var1);

    public long addNodeChangesListener(int var1, Set<NodeChangeType> var2);

    public void removeNodeChangesListener(long var1, Set<NodeChangeType> var3);

    public static class ImageDataOrIndex {
        public URI baseURI;
        public String[] composition;
        public String contentType;
        public byte[] imageData;

        public ImageDataOrIndex(URI imageURI) {
            this.baseURI = imageURI;
        }

        public ImageDataOrIndex baseURL(URL u) {
            try {
                this.baseURI = u == null ? null : u.toURI();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
            return this;
        }

        public ImageDataOrIndex baseURL(URI u) {
            this.baseURI = u;
            return this;
        }

        public ImageDataOrIndex composition(String[] composition) {
            this.composition = composition;
            return this;
        }

        public ImageDataOrIndex imageData(String contentType, byte[] imageData) {
            this.contentType = contentType;
            this.imageData = imageData;
            return this;
        }
    }
}

