/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.db;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.net.URL;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.java.lsp.server.db.Bundle;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class DBAddConnection
implements CommandProvider {
    public static final String DB_ADD_CONNECTION = "nbls.db.add.connection";
    public static final String USER_ID = "userId";
    public static final String PASSWORD = "password";
    public static final String DRIVER = "driver";
    public static final String DB_URL = "url";
    public static final String SCHEMA = "schema";
    public static final String DISPLAY_NAME = "displayName";
    private static final Logger LOG = Logger.getLogger(DBAddConnection.class.getName());
    private static final Map<String, String> urlTemplates = new HashMap<String, String>();
    private final Gson gson = new Gson();

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        if (arguments != null && !arguments.isEmpty()) {
            String driverClass;
            Map m = arguments.get(0) instanceof JsonNull ? Collections.emptyMap() : (Map)this.gson.fromJson((JsonElement)((JsonObject)arguments.get(0)), Map.class);
            String userId = m != null ? (String)m.get(USER_ID) : null;
            String password = m != null ? (String)m.get(PASSWORD) : null;
            String dbUrl = m != null ? (String)m.get(DB_URL) : null;
            String string = driverClass = m != null ? (String)m.get(DRIVER) : null;
            if (dbUrl != null && driverClass != null) {
                JDBCDriver[] driver = JDBCDriverManager.getDefault().getDrivers(driverClass);
                if (driver != null && driver.length > 0) {
                    if (userId == null || password == null) {
                        NotifyDescriptor.ComposedInput.Callback inputCallback = (input, number) -> {
                            switch (number) {
                                case 1: {
                                    NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine("", Bundle.MSG_EnterUsername());
                                    String userIdVal = userId != null ? userId : "";
                                    inputLine.setInputText(userIdVal);
                                    return inputLine;
                                }
                                case 2: {
                                    NotifyDescriptor.PasswordLine inputLine = new NotifyDescriptor.PasswordLine("", Bundle.MSG_EnterUsername());
                                    String passwordVal = password != null ? password : "";
                                    inputLine.setInputText(passwordVal);
                                    return inputLine;
                                }
                            }
                            return null;
                        };
                        DialogDisplayer.getDefault().notifyFuture((NotifyDescriptor)new NotifyDescriptor.ComposedInput(Bundle.MSG_AddDBConnection(), 2, inputCallback)).thenAccept(input -> {
                            String newUser = ((NotifyDescriptor.InputLine)input.getInputs()[0]).getInputText();
                            String newPasswd = ((NotifyDescriptor.InputLine)input.getInputs()[1]).getInputText();
                            DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)driver[0], (String)dbUrl, (String)newUser, (String)((String)m.get(SCHEMA)), (String)newPasswd, (boolean)true, (String)((String)m.get(DISPLAY_NAME)));
                            try {
                                ConnectionManager.getDefault().addConnection(dbconn);
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_ConnectionAdded(), 1));
                            }
                            catch (DatabaseException ex) {
                                LOG.log(Level.INFO, "Add connection", ex);
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
                            }
                        });
                    } else {
                        DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)driver[0], (String)dbUrl, (String)userId, (String)((String)m.get(SCHEMA)), (String)password, (boolean)true, (String)((String)m.get(DISPLAY_NAME)));
                        try {
                            ConnectionManager.getDefault().addConnection(dbconn);
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_ConnectionAdded(), 1));
                        }
                        catch (DatabaseException ex) {
                            LOG.log(Level.INFO, "Add connection with schema", ex);
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
                        }
                    }
                }
                return CompletableFuture.completedFuture(null);
            }
        }
        JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers();
        final ArrayList<NotifyDescriptor.QuickPick.Item> items = new ArrayList<NotifyDescriptor.QuickPick.Item>();
        final IdentityHashMap<NotifyDescriptor.QuickPick.Item, JDBCDriver> item2Driver = new IdentityHashMap<NotifyDescriptor.QuickPick.Item, JDBCDriver>();
        for (int i = 0; i < drivers.length; ++i) {
            FileObject jarFO;
            URL[] jars = drivers[i].getURLs();
            if (jars == null || jars.length <= 0 || (jarFO = URLMapper.findFileObject((URL)jars[0])) == null || !jarFO.isValid()) continue;
            NotifyDescriptor.QuickPick.Item item = new NotifyDescriptor.QuickPick.Item(drivers[i].getName(), drivers[i].getDisplayName() + " (" + drivers[i].getClassName() + ")");
            items.add(item);
            item2Driver.put(item, drivers[i]);
        }
        if (!items.isEmpty()) {
            final ArrayList schemas = new ArrayList();
            final IdentityHashMap item2Scheme = new IdentityHashMap();
            NotifyDescriptor.ComposedInput.Callback inputCallback = new NotifyDescriptor.ComposedInput.Callback(){
                final /* synthetic */ DBAddConnection this$0;
                {
                    this.this$0 = this$0;
                }

                public NotifyDescriptor createInput(NotifyDescriptor.ComposedInput input, int number) {
                    switch (number) {
                        case 1: {
                            return new NotifyDescriptor.QuickPick("", Bundle.MSG_SelectDriver(), items, false);
                        }
                        case 2: {
                            String urlTemplate;
                            JDBCDriver driver = (JDBCDriver)item2Driver.get(DBAddConnection.getSelectedItem((NotifyDescriptor.QuickPick)input.getInputs()[0]));
                            String string = urlTemplate = driver.getClassName() != null ? (String)urlTemplates.get(driver.getClassName()) : "";
                            if (urlTemplate == null) {
                                urlTemplate = "";
                            }
                            NotifyDescriptor.InputLine line = new NotifyDescriptor.InputLine("", Bundle.MSG_EnterDbUrl());
                            line.setInputText(urlTemplate);
                            return line;
                        }
                        case 3: {
                            return new NotifyDescriptor.InputLine("", Bundle.MSG_EnterUsername());
                        }
                        case 4: {
                            NotifyDescriptor.PasswordLine passwd = new NotifyDescriptor.PasswordLine("", Bundle.MSG_EnterPassword());
                            passwd.setInputTextEventEnabled(true);
                            passwd.addPropertyChangeListener(evt -> {
                                if (evt.getPropertyName() == null || "inputText".equals(evt.getPropertyName())) {
                                    this.validateConnection((NotifyDescriptor)passwd, input);
                                }
                            });
                            return passwd;
                        }
                        case 5: {
                            if (schemas.isEmpty()) {
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_ConnectionAdded(), 1));
                                return null;
                            }
                            ArrayList<NotifyDescriptor.QuickPick.Item> schemaItems = new ArrayList<NotifyDescriptor.QuickPick.Item>();
                            for (String schema : schemas) {
                                NotifyDescriptor.QuickPick.Item item = new NotifyDescriptor.QuickPick.Item(schema, schema);
                                schemaItems.add(item);
                                item2Scheme.put(item, schema);
                            }
                            return new NotifyDescriptor.QuickPick("", Bundle.MSG_SelectSchema(), schemaItems, false);
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void validateConnection(NotifyDescriptor current, NotifyDescriptor.ComposedInput input) {
                    JDBCDriver driver = (JDBCDriver)item2Driver.get(DBAddConnection.getSelectedItem((NotifyDescriptor.QuickPick)input.getInputs()[0]));
                    String url = ((NotifyDescriptor.InputLine)input.getInputs()[1]).getInputText();
                    String user = ((NotifyDescriptor.InputLine)input.getInputs()[2]).getInputText();
                    String passwd = ((NotifyDescriptor.InputLine)input.getInputs()[3]).getInputText();
                    boolean failed = true;
                    schemas.clear();
                    DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)driver, (String)url, (String)user, null, (String)passwd, (boolean)true);
                    try {
                        ConnectionManager.getDefault().addConnection(dbconn);
                        schemas.addAll(DBAddConnection.getSchemas(dbconn));
                        failed = false;
                    }
                    catch (SQLException ex) {
                        LOG.log(Level.INFO, "validate", ex);
                        current.createNotificationLineSupport().setErrorMessage(ex.getMessage());
                        current.setValid(false);
                    }
                    catch (DatabaseException ex) {
                        Throwable cause = ex.getCause();
                        if (cause == null) {
                            cause = ex;
                        }
                        String message = cause.getCause() != null ? Bundle.MSG_ConnectionFailed(url, user, cause.getCause().getMessage()) : cause.getMessage();
                        LOG.log(Level.INFO, "validate", ex);
                        current.createNotificationLineSupport().setErrorMessage(message);
                        current.setValid(false);
                    }
                    finally {
                        try {
                            if (failed || !schemas.isEmpty()) {
                                ConnectionManager.getDefault().removeConnection(dbconn);
                            }
                        }
                        catch (DatabaseException ex) {}
                    }
                }
            };
            return DialogDisplayer.getDefault().notifyFuture((NotifyDescriptor)new NotifyDescriptor.ComposedInput(Bundle.MSG_AddDBConnection(), 4, inputCallback)).thenApply(input -> {
                JDBCDriver driver = (JDBCDriver)item2Driver.get(DBAddConnection.getSelectedItem((NotifyDescriptor.QuickPick)input.getInputs()[0]));
                String url = ((NotifyDescriptor.InputLine)input.getInputs()[1]).getInputText();
                String user = ((NotifyDescriptor.InputLine)input.getInputs()[2]).getInputText();
                String passwd = ((NotifyDescriptor.InputLine)input.getInputs()[3]).getInputText();
                String schema = (String)item2Scheme.get(DBAddConnection.getSelectedItem((NotifyDescriptor.QuickPick)input.getInputs()[4]));
                if (driver != null && url != null && user != null && passwd != null && schema != null) {
                    DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)driver, (String)url, (String)user, (String)schema, (String)passwd, (boolean)true);
                    try {
                        ConnectionManager.getDefault().addConnection(dbconn);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_ConnectionAdded(), 1));
                    }
                    catch (DatabaseException ex) {
                        LOG.log(Level.INFO, "add", ex);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
                    }
                }
                return null;
            });
        }
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_DriverNotFound(), 0));
        return null;
    }

    private static NotifyDescriptor.QuickPick.Item getSelectedItem(NotifyDescriptor.QuickPick pick) {
        for (NotifyDescriptor.QuickPick.Item i : pick.getItems()) {
            if (!i.isSelected()) continue;
            return i;
        }
        return null;
    }

    private static List<String> getSchemas(DatabaseConnection dbconn) throws SQLException, DatabaseException {
        ResultSet rs;
        DatabaseMetaData dbMetaData;
        ArrayList<String> schemas = new ArrayList<String>();
        if (ConnectionManager.getDefault().connect(dbconn) && (dbMetaData = dbconn.getJDBCConnection().getMetaData()).supportsSchemasInTableDefinitions() && (rs = dbMetaData.getSchemas()) != null) {
            while (rs.next()) {
                schemas.add(rs.getString(1).trim());
            }
        }
        return schemas;
    }

    public Set<String> getCommands() {
        return Collections.singleton(DB_ADD_CONNECTION);
    }

    static {
        urlTemplates.put("org.postgresql.Driver", "jdbc:postgresql://<HOST>:5432/<DB>");
        urlTemplates.put("org.gjt.mm.mysql.Driver", "jdbc:mysql://<HOST>:3306/<DB>");
        urlTemplates.put("com.mysql.cj.jdbc.Driver", "jdbc:mysql://<HOST>:3306/<DB>");
        urlTemplates.put("org.mariadb.jdbc.Driver", "jdbc:mariadb://<HOST>:3306/<DB>");
        urlTemplates.put("oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@//<HOST>[:<PORT>][/<SERVICE>]");
        urlTemplates.put("com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://<HOST>\\<DB>[:<PORT>]");
    }
}

