/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.ui.Bundle;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

public final class NpmLibraries {
    private NpmLibraries() {
    }

    public static NodeFactory forHtml5Project() {
        return new NpmLibrariesNodeFactory();
    }

    public static NodeFactory forPhpProject() {
        return new NpmLibrariesNodeFactory();
    }

    public static NodeFactory forWebProject() {
        return new NpmLibrariesNodeFactory();
    }

    public static NodeFactory forMavenProject() {
        return new NpmLibrariesNodeFactory();
    }

    private static final class NpmLibrariesNodeFactory
    implements NodeFactory {
        private NpmLibrariesNodeFactory() {
        }

        public NodeList<?> createNodes(Project project) {
            assert (project != null);
            return new NpmLibrariesNodeList(project);
        }
    }

    private static final class CustomizeLibrariesAction
    extends AbstractAction {
        private final Project project;

        CustomizeLibrariesAction(Project project) {
            assert (project != null);
            this.project = project;
            String name = Bundle.CustomizeLibrariesAction_name();
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer("NpmLibraries", null);
        }
    }

    private static final class NpmLibraryInfo
    implements Comparable<NpmLibraryInfo> {
        final Image icon;
        final String name;
        final String description;

        NpmLibraryInfo(Image icon, String name, String descrition) {
            assert (icon != null);
            assert (name != null);
            assert (descrition != null);
            this.icon = icon;
            this.name = name;
            this.description = descrition;
        }

        @Override
        public int compareTo(NpmLibraryInfo other) {
            return this.name.compareToIgnoreCase(other.name);
        }

        public int hashCode() {
            int hash = 5;
            hash = 13 * hash + Objects.hashCode(this.name);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NpmLibraryInfo other = (NpmLibraryInfo)obj;
            return this.name.equalsIgnoreCase(other.name);
        }
    }

    private static final class NpmLibraryNode
    extends AbstractNode {
        private final NpmLibraryInfo libraryInfo;

        NpmLibraryNode(NpmLibraryInfo libraryInfo) {
            super(Children.LEAF);
            this.libraryInfo = libraryInfo;
        }

        public String getName() {
            return this.libraryInfo.name;
        }

        public String getShortDescription() {
            return this.libraryInfo.description;
        }

        public Image getIcon(int type) {
            return this.libraryInfo.icon;
        }

        public Image getOpenedIcon(int type) {
            return this.libraryInfo.icon;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private static final class NpmLibrariesChildren
    extends Children.Keys<NpmLibraryInfo> {
        private static final String LIBRARIES_ICON = "org/netbeans/modules/javascript/nodejs/ui/resources/libraries.gif";
        private static final String DEV_BADGE = "org/netbeans/modules/javascript/nodejs/ui/resources/libraries-dev-badge.gif";
        private static final String PEER_BADGE = "org/netbeans/modules/javascript/nodejs/ui/resources/libraries-peer-badge.png";
        private static final String OPTIONAL_BADGE = "org/netbeans/modules/javascript/nodejs/ui/resources/libraries-optional-badge.png";
        private final PackageJson packageJson;
        private final Map<String, Image> icons = new HashMap<String, Image>();

        public NpmLibrariesChildren(PackageJson packageJson) {
            super(true);
            assert (packageJson != null);
            this.packageJson = packageJson;
        }

        public boolean hasDependencies() {
            return !this.packageJson.getDependencies().isEmpty();
        }

        public void refreshDependencies() {
            this.setKeys();
        }

        protected Node[] createNodes(NpmLibraryInfo key) {
            return new Node[]{new NpmLibraryNode(key)};
        }

        protected void addNotify() {
            this.setKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        private void setKeys() {
            PackageJson.NpmDependencies dependencies = this.packageJson.getDependencies();
            if (dependencies.isEmpty()) {
                this.setKeys(Collections.emptyList());
                return;
            }
            ArrayList<NpmLibraryInfo> keys = new ArrayList<NpmLibraryInfo>(dependencies.getCount());
            keys.addAll(this.getKeys(dependencies.dependencies, null, null));
            keys.addAll(this.getKeys(dependencies.devDependencies, DEV_BADGE, Bundle.NpmLibrariesChildren_library_dev()));
            keys.addAll(this.getKeys(dependencies.optionalDependencies, OPTIONAL_BADGE, Bundle.NpmLibrariesChildren_library_optional()));
            keys.addAll(this.getKeys(dependencies.peerDependencies, PEER_BADGE, Bundle.NpmLibrariesChildren_library_peer()));
            this.setKeys(keys);
        }

        private List<NpmLibraryInfo> getKeys(Map<String, String> dependencies, String badge, String libraryType) {
            if (dependencies.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<NpmLibraryInfo> keys = new ArrayList<NpmLibraryInfo>(dependencies.size());
            for (Map.Entry<String, String> entry : dependencies.entrySet()) {
                String description = libraryType != null ? Bundle.NpmLibrariesChildren_description_long(entry.getKey(), entry.getValue(), libraryType) : Bundle.NpmLibrariesChildren_description_short(entry.getKey(), entry.getValue());
                keys.add(new NpmLibraryInfo(this.geIcon(badge), entry.getKey(), description));
            }
            Collections.sort(keys);
            return keys;
        }

        private Image geIcon(String badge) {
            Image icon = this.icons.get(badge);
            if (icon == null) {
                icon = ImageUtilities.loadImage((String)LIBRARIES_ICON);
                if (badge != null) {
                    icon = ImageUtilities.mergeImages((Image)icon, (Image)ImageUtilities.loadImage((String)badge), (int)8, (int)8);
                }
                this.icons.put(badge, icon);
            }
            return icon;
        }
    }

    private static final class NpmLibrariesNode
    extends AbstractNode {
        private static final String LIBRARIES_BADGE = "org/netbeans/modules/javascript/nodejs/ui/resources/libraries-badge.png";
        private final Project project;
        private final Node iconDelegate;

        NpmLibrariesNode(Project project, NpmLibrariesChildren npmLibrariesChildren) {
            super((Children)npmLibrariesChildren);
            assert (project != null);
            this.project = project;
            this.iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
        }

        public String getDisplayName() {
            return Bundle.NpmLibrariesNode_name();
        }

        public Image getIcon(int type) {
            return ImageUtilities.mergeImages((Image)this.iconDelegate.getIcon(type), (Image)ImageUtilities.loadImage((String)LIBRARIES_BADGE), (int)7, (int)7);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new CustomizeLibrariesAction(this.project)};
        }
    }

    private static final class NpmLibrariesNodeList
    implements NodeList<Node>,
    PropertyChangeListener {
        private final Project project;
        private final PackageJson packageJson;
        private final NpmLibrariesChildren npmLibrariesChildren;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Node npmLibrariesNode;

        NpmLibrariesNodeList(Project project) {
            assert (project != null);
            this.project = project;
            this.packageJson = new PackageJson(project.getProjectDirectory());
            this.npmLibrariesChildren = new NpmLibrariesChildren(this.packageJson);
        }

        public List<Node> keys() {
            if (!this.npmLibrariesChildren.hasDependencies()) {
                return Collections.emptyList();
            }
            if (this.npmLibrariesNode == null) {
                this.npmLibrariesNode = new NpmLibrariesNode(this.project, this.npmLibrariesChildren);
            }
            return Collections.singletonList(this.npmLibrariesNode);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public Node node(Node key) {
            return key;
        }

        public void addNotify() {
            this.packageJson.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.packageJson));
        }

        public void removeNotify() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("DEPENDENCIES".equals(propertyName) || "DEV_DEPENDENCIES".equals(propertyName) || "PEER_DEPENDENCIES".equals(propertyName) || "OPTIONAL_DEPENDENCIES".equals(propertyName)) {
                this.fireChange();
            }
        }

        private void fireChange() {
            this.npmLibrariesChildren.refreshDependencies();
            this.changeSupport.fireChange();
        }
    }
}

