/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.editor;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.NodeExecutable;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.web.common.api.Version;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public final class NodeJsSupportImpl
implements org.netbeans.modules.javascript2.nodejs.spi.NodeJsSupport {
    private static final String NODEJS_DOC_URL = "https://nodejs.org/docs/v%s/api/";
    private static final String IOJS_DOC_URL = "https://iojs.org/dist/v%s/doc/api/";
    private final Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final PropertyChangeListener nodeJsChangeListener = new NodeJsChangeListener();
    private NodeJsSupport nodeJsSupport = null;

    public NodeJsSupportImpl(Project project) {
        this.project = project;
    }

    public boolean isSupportEnabled() {
        return this.getNodeJsSupport().getPreferences().isEnabled();
    }

    public Version getVersion() {
        assert (!EventQueue.isDispatchThread()) : "Should not be called in the UI thread";
        NodeExecutable node = NodeExecutable.forProject(this.project, false);
        if (node == null) {
            return null;
        }
        return node.getVersion();
    }

    public String getDocumentationUrl() {
        assert (!EventQueue.isDispatchThread()) : "Should not be called in the UI thread";
        NodeExecutable node = NodeExecutable.forProject(this.project, false);
        if (node == null) {
            return null;
        }
        Version version = node.getVersion();
        if (version == null) {
            return null;
        }
        return String.format(node.isIojs() ? IOJS_DOC_URL : NODEJS_DOC_URL, version.toString());
    }

    public FileObject getDocumentationFolder() {
        assert (!EventQueue.isDispatchThread()) : "Should not be called in the UI thread";
        File nodeSources = NodeJsUtils.getNodeSources(this.project);
        if (nodeSources == null) {
            return null;
        }
        FileObject sources = FileUtil.toFileObject((File)nodeSources);
        if (sources == null) {
            return null;
        }
        return sources.getFileObject("doc");
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private synchronized NodeJsSupport getNodeJsSupport() {
        if (this.nodeJsSupport == null) {
            this.nodeJsSupport = NodeJsSupport.forProject(this.project);
            this.nodeJsSupport.addPropertyChangeListener(this.nodeJsChangeListener);
        }
        return this.nodeJsSupport;
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private final class NodeJsChangeListener
    implements PropertyChangeListener {
        private NodeJsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("ENABLED".equals(propertyName) || "SOURCE_ROOTS".equals(propertyName)) {
                NodeJsSupportImpl.this.fireChange();
            }
        }
    }
}

