/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.util.prefs.Preferences;
import org.netbeans.modules.tasklist.impl.ScanningScopeList;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.util.NbPreferences;

public class Settings {
    private static final String PREF_FOLDING_WIDTH = "folding_table_col_";
    private static final String PREF_REGULAR_WIDTH = "table_col_";
    private static Settings theInstance;
    private Preferences prefs = NbPreferences.forModule(Settings.class);

    private Settings() {
    }

    public static Settings getDefault() {
        if (null == theInstance) {
            theInstance = new Settings();
        }
        return theInstance;
    }

    public int getSortingColumn() {
        return this.prefs.getInt("sortingColumn", -1);
    }

    public void setSortingColumn(int col) {
        this.prefs.putInt("sortingColumn", col);
    }

    public boolean isAscendingSort() {
        return this.prefs.getBoolean("sortingAscending", true);
    }

    public void setAscendingSort(boolean asc) {
        this.prefs.putBoolean("sortingAscending", asc);
    }

    public float getPreferredColumnWidth(int col, boolean foldingTable, float defaultValue) {
        return this.prefs.getFloat((foldingTable ? PREF_FOLDING_WIDTH : PREF_REGULAR_WIDTH) + col, defaultValue);
    }

    public void setPreferredColumnWidth(int col, boolean foldingTable, float colWidth) {
        this.prefs.putFloat((foldingTable ? PREF_FOLDING_WIDTH : PREF_REGULAR_WIDTH) + col, colWidth);
    }

    public boolean isGroupExpanded(String groupName) {
        return this.prefs.getBoolean("expanded_" + groupName, true);
    }

    public void setGroupExpanded(String groupName, boolean expand) {
        this.prefs.putBoolean("expanded_" + groupName, expand);
    }

    public void setActiveScanningScope(TaskScanningScope scope) {
        this.prefs.put("activeScanningScope", scope.getClass().getName());
    }

    public TaskScanningScope getActiveScanningScope() {
        String clazzName = this.prefs.get("activeScanningScope", null);
        if (null != clazzName) {
            for (TaskScanningScope scope : ScanningScopeList.getDefault().getTaskScanningScopes()) {
                if (!scope.getClass().getName().equals(clazzName)) continue;
                return scope;
            }
        }
        return null;
    }

    public void setGroupTasksByCategory(boolean group) {
        this.prefs.putBoolean("groupTasksByCategory", group);
    }

    public boolean getGroupTasksByCategory() {
        return this.prefs.getBoolean("groupTasksByCategory", false);
    }
}

