/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.dependencies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.dependencies.RewriteContext;
import org.netbeans.modules.gradle.java.queries.GradleScope;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyChange;
import org.netbeans.modules.project.dependency.DependencyChangeException;

public abstract class AbstractWorker {
    protected final Project project;
    protected DependencyChange request;
    protected final RewriteContext context;
    protected final List<Dependency> accepted = new ArrayList<Dependency>();
    protected List<TextEdit> textEdits = new ArrayList<TextEdit>();
    protected LineDocument lineDoc;
    protected Map<Dependency, Dependency> offending = new HashMap<Dependency, Dependency>();

    public AbstractWorker(Project project, RewriteContext context) {
        this.project = project;
        this.context = context;
    }

    static StringBuilder indent(StringBuilder sb, int size) {
        for (int i = 0; i < size; ++i) {
            sb.append(" ");
        }
        return sb;
    }

    protected abstract boolean checkDependencyConflicts(Dependency var1, Dependency var2) throws DependencyChangeException;

    protected abstract void throwDependencyConflicts() throws DependencyChangeException;

    protected abstract void generateDependencies() throws DependencyChangeException;

    protected GradleScope getScope(Dependency d) throws DependencyChangeException {
        GradleScope gs = this.context.getScopes().toGradleScope(d.getScope().name());
        if (gs == null) {
            this.throwUnknownScope(d);
        }
        return gs;
    }

    protected void throwUnknownScope(Dependency d) throws DependencyChangeException {
        throw new DependencyChangeException(this.request, d, DependencyChangeException.Reason.MALFORMED);
    }

    protected void recordConflict(Dependency requested, Dependency existing) {
        if (!this.request.getOptions().contains(DependencyChange.Options.skipConflicts)) {
            this.offending.putIfAbsent(requested, existing);
        }
    }

    public void processRequest(DependencyChange change) throws DependencyChangeException {
        this.request = change;
        for (Dependency d : this.request.getDependencies()) {
            boolean toAccept = true;
            for (Dependency c : this.context.getCurrentDependencies().getRoot().getChildren()) {
                if (this.checkDependencyConflicts(c, d)) continue;
                toAccept = false;
                break;
            }
            if (!toAccept) continue;
            this.accepted.add(d);
        }
        this.throwDependencyConflicts();
        this.request = null;
    }

    public void execute() throws DependencyChangeException {
        this.lineDoc = this.context.openDocument();
        this.generateDependencies();
        this.context.addTextEdits(this.textEdits);
    }
}

