/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.stream.Stream;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.api.GradleProjects;
import org.netbeans.modules.gradle.java.queries.Bundle;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class GradleSourceAttacherImpl
implements SourceJavadocAttacherImplementation.Definer2 {
    private static final String REQUESTED_COMPONENT = "requestedComponent";
    private static final String COMMAND_DL_SOURCES = "download.sources";
    private static final String COMMAND_DL_JAVADOC = "download.javadoc";
    private volatile Reference<Cached> lastChecked = new WeakReference<Object>(null);

    public boolean accepts(URL root) {
        return this.cachedRootInfo(root) != null;
    }

    public String getDisplayName() {
        return Bundle.LABEL_GradleSourceDefiner();
    }

    public String getDescription() {
        return Bundle.DESC_GradleSourceDefiner();
    }

    public List<? extends URL> getSources(URL root, Callable<Boolean> cancel) {
        return new Worker(root, true, cancel).download();
    }

    public List<? extends URL> getJavadoc(URL root, Callable<Boolean> cancel) {
        return new Worker(root, false, cancel).download();
    }

    private File findGradleCachedArtifact(URL r) {
        if (!FileUtil.isArchiveArtifact((URL)r)) {
            return null;
        }
        URL archive = FileUtil.getArchiveFile((URL)r);
        if (archive == null) {
            return null;
        }
        FileObject fo = URLMapper.findFileObject((URL)archive);
        if (fo == null) {
            return null;
        }
        File maybeArtifact = FileUtil.toFile((FileObject)fo);
        return GradleProjects.isGradleCacheArtifact((File)maybeArtifact) ? maybeArtifact : null;
    }

    private E[] findOwnerProjects(URL u, File f) {
        Cached c = this.lastChecked.get();
        if (c != null && u.toString().equals(c.u.toString())) {
            return c.projectsAndModules;
        }
        ArrayList fallbacks = new ArrayList();
        ArrayList<E> result = new ArrayList<E>();
        for (Project candidate : OpenProjects.getDefault().getOpenProjects()) {
            GradleBaseProject gbp = GradleBaseProject.get((Project)candidate);
            if (gbp == null) continue;
            boolean resolved = gbp.isResolved();
            GradleDependency.ModuleDependency dep = this.checkGradleContains(candidate, f);
            if (dep == null) continue;
            (resolved ? result : fallbacks).add(new E(candidate, dep));
        }
        result.addAll(fallbacks);
        c = new Cached(u, result.toArray(new E[0]));
        this.lastChecked = new WeakReference<Cached>(c);
        return c.projectsAndModules;
    }

    private GradleDependency.ModuleDependency checkGradleContains(Project p, File f) {
        GradleBaseProject gbp = GradleBaseProject.get((Project)p);
        if (p == null) {
            return null;
        }
        ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (ap == null) {
            return null;
        }
        List<String> s = Arrays.asList(ap.getSupportedActions());
        if (!s.contains(COMMAND_DL_JAVADOC) && !s.contains(COMMAND_DL_SOURCES)) {
            return null;
        }
        File absF = f.getAbsoluteFile();
        Stream mods = gbp.getConfigurations().values().stream().flatMap(cfg -> cfg.getModules().stream());
        return mods.filter(m -> m.getArtifacts().contains(absF)).findFirst().orElse(null);
    }

    E[] cachedRootInfo(URL u) {
        Cached c = this.lastChecked.get();
        if (c != null && u.toString().equals(c.u.toString())) {
            return c.projectsAndModules;
        }
        File a = this.findGradleCachedArtifact(u);
        if (a == null) {
            return null;
        }
        E[] result = this.findOwnerProjects(u, a);
        return result != null && result.length > 0 ? result : null;
    }

    private static class E {
        final Project project;
        final GradleDependency.ModuleDependency dep;

        public E(Project project, GradleDependency.ModuleDependency dep) {
            this.project = project;
            this.dep = dep;
        }
    }

    class Worker
    extends ActionProgress
    implements Runnable {
        private final URL root;
        private final E[] locations;
        private final Callable<Boolean> cancel;
        private final boolean sources;
        private final Semaphore sync = new Semaphore(0);
        private final SourceJavadocAttacher.AttachmentListener listener;
        private volatile Boolean result;

        public Worker(URL root, boolean sources, Callable<Boolean> cancel) {
            this.root = root;
            this.sources = sources;
            this.cancel = cancel;
            this.listener = null;
            this.locations = GradleSourceAttacherImpl.this.cachedRootInfo(root);
        }

        public Worker(URL root, boolean sources, E[] locations, SourceJavadocAttacher.AttachmentListener listener) {
            this.root = root;
            this.sources = sources;
            this.cancel = () -> false;
            this.locations = locations;
            this.listener = listener;
        }

        @Override
        public void run() {
            this.download();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<? extends URL> download() {
            boolean ok = false;
            try {
                List<? extends URL> ret = this.download0();
                ok = ret != null && !ret.isEmpty();
                List<? extends URL> list = ret;
                return list;
            }
            finally {
                if (this.listener != null) {
                    if (ok) {
                        this.listener.attachmentSucceeded();
                    } else {
                        this.listener.attachmentFailed();
                    }
                }
            }
        }

        List<? extends URL> download0() {
            if (this.locations == null) {
                return Collections.emptyList();
            }
            for (E l : this.locations) {
                FileObject[] fobs;
                try {
                    if (this.cancel.call().booleanValue()) {
                        return Collections.emptyList();
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return Collections.emptyList();
                }
                if (!this.invokeWaitDownloadAction((ActionProvider)l.project.getLookup().lookup(ActionProvider.class), this.sources ? GradleSourceAttacherImpl.COMMAND_DL_SOURCES : GradleSourceAttacherImpl.COMMAND_DL_JAVADOC, l.dep) || (fobs = SourceForBinaryQuery.findSourceRoots((URL)this.root).getRoots()).length == 0) continue;
                ArrayList<URL> res = new ArrayList<URL>();
                for (FileObject ff : fobs) {
                    URL u = URLMapper.findURL((FileObject)ff, (int)0);
                    if (u == null) continue;
                    res.add(u);
                }
                if (res.isEmpty()) continue;
                return res;
            }
            return Collections.emptyList();
        }

        /*
         * Exception decompiling
         */
        boolean invokeWaitDownloadAction(ActionProvider ap, String command, GradleDependency.ModuleDependency dep) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void started() {
        }

        public void finished(boolean success) {
            this.result = success;
            this.sync.release();
        }
    }

    private static class Cached {
        final URL u;
        final E[] projectsAndModules;

        public Cached(URL u, E[] projectsAndModules) {
            this.u = u;
            this.projectsAndModules = projectsAndModules;
        }
    }
}

