/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.output;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.api.output.OutputDisplayer;
import org.netbeans.modules.gradle.api.output.OutputProcessor;
import org.netbeans.modules.gradle.api.output.OutputProcessorFactory;
import org.netbeans.modules.gradle.java.spi.debug.GradleJavaDebugger;
import org.openide.windows.IOColors;

public class JDPAProcessorFactory
implements OutputProcessorFactory {
    public Set<? extends OutputProcessor> createOutputProcessors(RunConfig cfg) {
        return Collections.singleton(new JDPAOutputProcessor(cfg));
    }

    private static class JDPAOutputProcessor
    implements OutputProcessor {
        private static final Pattern JDPA_LISTEN = Pattern.compile("Listening for transport dt_socket at address: (\\d+)");
        final RunConfig cfg;
        boolean activated;

        public JDPAOutputProcessor(RunConfig cfg) {
            this.cfg = cfg;
        }

        public boolean processLine(OutputDisplayer out, String line) {
            Matcher m = JDPA_LISTEN.matcher(line);
            if (m.matches()) {
                if (!this.activated) {
                    String portStr = m.group(1);
                    GradleJavaDebugger dbg = (GradleJavaDebugger)this.cfg.getProject().getLookup().lookup(GradleJavaDebugger.class);
                    if (dbg != null) {
                        try {
                            dbg.attachDebugger(this.cfg.getTaskDisplayName(), "dt_socket", "localhost", portStr);
                            this.activated = true;
                        }
                        catch (Exception ex) {
                            out.print(ex.getCause().getMessage(), null, IOColors.OutputType.ERROR);
                        }
                    }
                    out.print(line, null, IOColors.OutputType.LOG_DEBUG);
                } else {
                    RunUtils.cancelGradle((RunConfig)this.cfg);
                }
                return true;
            }
            return false;
        }
    }
}

