/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class ListBranchCommand
extends GitCommand {
    private final boolean all;
    private Map<String, GitBranch> branches;

    public ListBranchCommand(Repository repository, GitClassFactory gitFactory, boolean all, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.all = all;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        this.branches = new LinkedHashMap<String, GitBranch>();
        try {
            RefDatabase db = repository.getRefDatabase();
            Ref head = db.exactRef("HEAD");
            if (head != null) {
                String current = head.getLeaf().getName();
                if (current.equals("HEAD")) {
                    String name = "(no branch)";
                    this.branches.put(name, this.getClassFactory().createBranch(name, false, true, head.getLeaf().getObjectId()));
                }
                this.branches.putAll(this.getRefs(db.getRefsByPrefix("refs/heads/"), false, current));
            }
            Map<String, GitBranch> allBranches = this.getRefs(db.getRefsByPrefix("refs/remotes/"), true, null);
            allBranches.putAll(this.branches);
            this.setupTracking(this.branches, allBranches, (Config)repository.getConfig());
            if (this.all) {
                this.branches.putAll(allBranches);
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new GitException("Corrupted repository metadata at " + repository.getWorkTree().getAbsolutePath(), ex);
        }
    }

    private Map<String, GitBranch> getRefs(Collection<Ref> allRefs, boolean isRemote, String activeBranch) {
        LinkedHashMap<String, GitBranch> branchMap = new LinkedHashMap<String, GitBranch>();
        for (Ref ref : RefComparator.sort(allRefs)) {
            String refName = ref.getLeaf().getName();
            String name = refName.substring(refName.indexOf(47, 5) + 1);
            branchMap.put(name, this.getClassFactory().createBranch(name, isRemote, refName.equals(activeBranch), ref.getLeaf().getObjectId()));
        }
        return branchMap;
    }

    @Override
    protected String getCommandDescription() {
        return "git branch";
    }

    public Map<String, GitBranch> getBranches() {
        return this.branches;
    }

    private void setupTracking(Map<String, GitBranch> branches, Map<String, GitBranch> allBranches, Config cfg) {
        for (GitBranch b : branches.values()) {
            this.getClassFactory().setBranchTracking(b, Utils.getTrackedBranch(cfg, b.getName(), allBranches));
        }
    }
}

