/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ear;

import java.io.IOException;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.dd.api.application.Web;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation2;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.javaee.project.spi.ear.EarDDGeneratorImplementation;
import org.netbeans.modules.maven.j2ee.ear.EarModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class EarDDGeneratorImpl
implements EarDDGeneratorImplementation {
    private static final String APPLICATION_XML = "application.xml";
    private final Project project;

    public EarDDGeneratorImpl(Project project) {
        this.project = project;
    }

    public FileObject setupDD(boolean force) {
        J2eeApplicationProvider applicationProvider = (J2eeApplicationProvider)this.project.getLookup().lookup(J2eeApplicationProvider.class);
        if (applicationProvider != null) {
            Profile profile = JavaEEProjectSettings.getProfile((Project)this.project);
            return this.createApplicationXML(this.project, profile, applicationProvider.getChildModuleProviders());
        }
        return null;
    }

    public FileObject createApplicationXML(Project project, Profile profile, J2eeModuleProvider[] childProviders) {
        EarModuleProviderImpl earProvider = (EarModuleProviderImpl)((Object)project.getLookup().lookup(EarModuleProviderImpl.class));
        if (earProvider != null) {
            EarImplementation2 earImpl = earProvider.getEarImplementation();
            FileObject applicationXML = earImpl.getDeploymentDescriptor();
            FileObject metaInf = earImpl.getMetaInf();
            if (applicationXML == null) {
                return this.setupApplicationXML(profile, metaInf, project, childProviders, true);
            }
        }
        return null;
    }

    private FileObject setupApplicationXML(Profile profile, FileObject docBase, Project project, J2eeModuleProvider[] childProviders, boolean force) {
        try {
            FileObject dd = docBase.getFileObject(APPLICATION_XML);
            if (dd == null && (force || DDHelper.isApplicationXMLCompulsory((Project)project))) {
                dd = DDHelper.createApplicationXml((Profile)profile, (FileObject)docBase, (boolean)true);
            }
            if (dd != null) {
                Application app = DDProvider.getDefault().getDDRoot(dd);
                app.setDisplayName(ProjectUtils.getInformation((Project)project).getDisplayName());
                if (app.getModule().length == 0 && childProviders.length > 0) {
                    for (J2eeModuleProvider moduleProvider : childProviders) {
                        this.addModuleToDD(app, moduleProvider);
                    }
                }
                app.write(dd);
            }
            return dd;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void addModuleToDD(Application app, J2eeModuleProvider moduleProvider) {
        J2eeModule j2eeModule = moduleProvider.getJ2eeModule();
        J2eeModule.Type type = j2eeModule.getType();
        try {
            Module module = (Module)app.createBean("Module");
            String path = j2eeModule.getUrl();
            if (J2eeModule.Type.EJB.equals(type)) {
                module.setEjb(path + ".jar");
            } else if (J2eeModule.Type.WAR.equals(type)) {
                Web w = module.newWeb();
                w.setWebUri(path + ".war");
                if (moduleProvider instanceof WebModuleProviderImpl) {
                    WebModuleImpl webModuleImpl = ((WebModuleProviderImpl)moduleProvider).getModuleImpl();
                    String contextPath = webModuleImpl.getContextPath();
                    if (!contextPath.isEmpty()) {
                        w.setContextRoot(contextPath);
                    } else {
                        w.setContextRoot("/");
                    }
                }
                module.setWeb(w);
            } else if (J2eeModule.Type.RAR.equals(type)) {
                module.setConnector(path);
            } else if (J2eeModule.Type.CAR.equals(type)) {
                module.setJava(path);
            }
            app.addModule(module);
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

