/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui.actions;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.api.TestNGUtils;
import org.netbeans.modules.testng.spi.TestConfig;
import org.netbeans.modules.testng.spi.TestNGSupportImplementation;
import org.netbeans.modules.testng.ui.actions.TestClassInfoTask;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class TestNGActionProvider
implements ActionProvider {
    private static final Logger LOGGER = Logger.getLogger(TestNGActionProvider.class.getName());
    private static final String[] SUPPORTED_ACTIONS = new String[]{"run.single.method", "debug.single.method"};

    public String[] getSupportedActions() {
        return SUPPORTED_ACTIONS;
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        return context.lookup(SingleMethod.class) != null;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        TestNGSupport.Action action = "run.single.method".equals(command) ? TestNGSupport.Action.RUN_TESTMETHOD : TestNGSupport.Action.DEBUG_TESTMETHOD;
        SingleMethod sm = (SingleMethod)context.lookup(SingleMethod.class);
        FileObject fo = sm.getFile();
        TestClassInfoTask task = new TestClassInfoTask(0);
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        try {
            js.runUserActionTask((Task)task, true);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        TestNGSupportImplementation.TestExecutor exec = TestNGSupport.findTestNGSupport((Project)p).createExecutor(p);
        TestConfig conf = TestNGUtils.getTestConfig((FileObject)fo, (boolean)false, (String)task.getPackageName(), (String)task.getClassName(), (String)sm.getMethodName());
        try {
            exec.execute(action, conf);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }
}

