/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.metrics.hints;

import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.WhileLoopTree;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;

public final class CyclomaticComplexityVisitor
extends ErrorAwareTreePathScanner<Object, Object> {
    private int complexity;
    private boolean inClass;
    private boolean switchCase;

    public Object visitClass(ClassTree node, Object p) {
        if (!this.inClass) {
            this.inClass = true;
            Object r = super.visitClass(node, p);
            this.inClass = false;
            return r;
        }
        return null;
    }

    public Object visitDoWhileLoop(DoWhileLoopTree node, Object p) {
        boolean saveFlag = this.switchCase;
        this.switchCase = false;
        ++this.complexity;
        Object o = super.visitDoWhileLoop(node, p);
        this.switchCase = saveFlag;
        return o;
    }

    public Object visitWhileLoop(WhileLoopTree node, Object p) {
        boolean saveFlag = this.switchCase;
        this.switchCase = false;
        ++this.complexity;
        Object o = super.visitWhileLoop(node, p);
        this.switchCase = saveFlag;
        return o;
    }

    public Object visitForLoop(ForLoopTree node, Object p) {
        boolean saveFlag = this.switchCase;
        this.switchCase = false;
        ++this.complexity;
        Object o = super.visitForLoop(node, p);
        this.switchCase = saveFlag;
        return o;
    }

    public Object visitEnhancedForLoop(EnhancedForLoopTree node, Object p) {
        boolean saveFlag = this.switchCase;
        this.switchCase = false;
        ++this.complexity;
        Object o = super.visitEnhancedForLoop(node, p);
        this.switchCase = saveFlag;
        return o;
    }

    public Object visitCase(CaseTree node, Object p) {
        if (node.getStatements() != null) {
            ++this.complexity;
        }
        boolean saveFlag = this.switchCase;
        this.switchCase = true;
        Object o = super.visitCase(node, p);
        this.switchCase = saveFlag;
        return o;
    }

    public Object visitCatch(CatchTree node, Object p) {
        ++this.complexity;
        return super.visitCatch(node, p);
    }

    public Object visitConditionalExpression(ConditionalExpressionTree node, Object p) {
        ++this.complexity;
        return super.visitConditionalExpression(node, p);
    }

    public Object visitIf(IfTree node, Object p) {
        ++this.complexity;
        return super.visitIf(node, p);
    }

    public Object visitBreak(BreakTree node, Object p) {
        if (node.getLabel() != null || !this.switchCase) {
            ++this.complexity;
        }
        return super.visitBreak(node, p);
    }

    public Object visitContinue(ContinueTree node, Object p) {
        ++this.complexity;
        return super.visitContinue(node, p);
    }

    public Object visitThrow(ThrowTree node, Object p) {
        ++this.complexity;
        return super.visitThrow(node, p);
    }

    public int getComplexity() {
        return this.complexity;
    }

    public void reset() {
        this.complexity = 0;
        this.switchCase = false;
    }
}

