/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.metrics.hints;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.metrics.hints.Bundle;
import org.netbeans.modules.java.metrics.hints.CyclomaticComplexityVisitor;
import org.netbeans.modules.java.metrics.hints.DependencyCollector;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class ClassMetrics {
    static final int DEFAULT_ANONYMOUS_COMPLEXITY_LIMIT = 5;
    static final int DEFAULT_COMPLEXITY_LIMIT = 80;
    static final int DEFAULT_COUPLING_LIMIT = 25;
    static final int DEFAULT_CLASS_FIELDS_LIMIT = 10;
    static final int DEFAULT_CLASS_METHODS_LIMIT = 20;
    static final int DEFAULT_ANON_CLASS_METHODS_LIMIT = 3;
    static final int DEFAULT_CLASS_CONSTRUCTORS_LIMIT = 5;
    static final boolean DEFAULT_COUPLING_IGNORE_JAVA = true;
    static final boolean DEFAULT_CLASS_METHODS_IGNORE_ACCESSORS = true;
    static final boolean DEFAULT_CLASS_FIELDS_IGNORE_CONSTANTS = true;
    static final boolean DEFAULT_CLASS_METHODS_IGNORE_ABSTRACT = true;
    public static final String OPTION_ANONYMOUS_COMPLEXITY_LIMIT = "metrics.class.anonymous.complexity.limit";
    public static final String OPTION_COMPLEXITY_LIMIT = "metrics.class.complexity.limit";
    public static final String OPTION_COUPLING_LIMIT = "metrics.class.coupling.limit";
    public static final String OPTION_COUPLING_IGNORE_JAVA = "metrics.class.coupling.nojava";
    public static final String OPTION_CLASS_CONSTRUCTORS_LIMIT = "metrics.class.constructors.limit";
    public static final String OPTION_CLASS_METHODS_LIMIT = "metrics.class.methods.limit";
    public static final String OPTION_ANON_CLASS_METHODS_LIMIT = "metrics.anonclass.methods.limit";
    public static final String OPTION_CLASS_METHODS_IGNORE_ACCESSORS = "metrics.class.methods.ignoreaccessors";
    public static final String OPTION_CLASS_METHODS_IGNORE_ABSTRACT = "metrics.class.methods.ignoreabstract";
    public static final String OPTION_CLASS_FIELDS_LIMIT = "metrics.class.fields.limit";
    public static final String OPTION_CLASS_FIELDS_IGNORE_CONSTANTS = "metrics.class.fields.ignoreconst";
    private static final Collection<Modifier> CONSTANT_MODS = EnumSet.of(Modifier.STATIC, Modifier.FINAL);

    public static ErrorDescription tooComplexAnonymousClass(HintContext ctx) {
        CyclomaticComplexityVisitor v = new CyclomaticComplexityVisitor();
        v.scan(ctx.getPath(), null);
        int complexity = v.getComplexity();
        int limit = ctx.getPreferences().getInt(OPTION_ANONYMOUS_COMPLEXITY_LIMIT, 5);
        if (complexity > limit) {
            CompilationInfo info = ctx.getInfo();
            SourcePositions pos = info.getTrees().getSourcePositions();
            NewClassTree nct = (NewClassTree)ctx.getPath().getLeaf();
            long start = pos.getStartPosition(info.getCompilationUnit(), nct);
            long mstart = pos.getStartPosition(info.getCompilationUnit(), nct.getClassBody());
            return ErrorDescriptionFactory.forSpan((HintContext)ctx, (int)((int)start), (int)((int)mstart), (String)Bundle.TEXT_ClassAnonymousTooComplex(complexity), (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription tooComplexClass(HintContext ctx) {
        ClassTree clazz = (ClassTree)ctx.getPath().getLeaf();
        TypeElement e = (TypeElement)ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (e.getNestingKind() == NestingKind.ANONYMOUS) {
            return null;
        }
        CyclomaticComplexityVisitor v = new CyclomaticComplexityVisitor();
        v.scan(ctx.getPath(), null);
        int complexity = v.getComplexity();
        int limit = ctx.getPreferences().getInt(OPTION_COMPLEXITY_LIMIT, 80);
        if (complexity > limit) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_ClassTooComplex(clazz.getSimpleName().toString(), complexity), (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription tooCoupledClass(HintContext ctx) {
        ClassTree clazz = (ClassTree)ctx.getPath().getLeaf();
        DependencyCollector col = new DependencyCollector(ctx.getInfo());
        boolean ignoreJava = ctx.getPreferences().getBoolean(OPTION_COUPLING_IGNORE_JAVA, true);
        col.setIgnoreJavaLibraries(ignoreJava);
        col.scan(ctx.getPath(), null);
        int coupling = col.getSeenQNames().size();
        int limit = ctx.getPreferences().getInt(OPTION_COUPLING_LIMIT, 25);
        if (coupling > limit) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_ClassTooCoupled(clazz.getSimpleName().toString(), coupling), (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription tooManyConstructors(HintContext ctx) {
        ClassTree clazz = (ClassTree)ctx.getPath().getLeaf();
        int methodCount = 0;
        for (Tree tree : clazz.getMembers()) {
            MethodTree method;
            if (tree.getKind() != Tree.Kind.METHOD || (method = (MethodTree)tree).getReturnType() != null) continue;
            ++methodCount;
        }
        int limit = ctx.getPreferences().getInt(OPTION_CLASS_CONSTRUCTORS_LIMIT, 5);
        if (methodCount <= limit) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_ClassManyConstructors(clazz.getSimpleName().toString(), methodCount), (Fix[])new Fix[0]);
    }

    public static ErrorDescription anonymousTooManyMethods(HintContext ctx) {
        NewClassTree nct = (NewClassTree)ctx.getPath().getLeaf();
        return ClassMetrics.checkTooManyMethods(ctx, new TreePath(ctx.getPath(), nct.getClassBody()), ctx.getPreferences().getInt(OPTION_ANON_CLASS_METHODS_LIMIT, 3), true);
    }

    public static ErrorDescription tooManyMethods(HintContext ctx) {
        return ClassMetrics.checkTooManyMethods(ctx, ctx.getPath(), ctx.getPreferences().getInt(OPTION_CLASS_METHODS_LIMIT, 20), false);
    }

    private static ErrorDescription checkTooManyMethods(HintContext ctx, TreePath path, int limit, boolean anon) {
        ClassTree clazz = (ClassTree)path.getLeaf();
        boolean ignoreAccessors = ctx.getPreferences().getBoolean(OPTION_CLASS_METHODS_IGNORE_ACCESSORS, true);
        boolean ignoreAbstract = ctx.getPreferences().getBoolean(OPTION_CLASS_METHODS_IGNORE_ABSTRACT, true);
        int methodCount = 0;
        for (Tree tree : clazz.getMembers()) {
            MethodTree method;
            if (tree.getKind() != Tree.Kind.METHOD || (method = (MethodTree)tree).getReturnType() == null) continue;
            TreePath methodPath = new TreePath(path, method);
            if (ignoreAccessors && (ClassMetrics.isSimpleGetter(ctx.getInfo(), methodPath) || ClassMetrics.isSimpleSetter(ctx.getInfo(), methodPath))) continue;
            if (ignoreAbstract) {
                ExecutableElement mel = (ExecutableElement)ctx.getInfo().getTrees().getElement(methodPath);
                ExecutableElement overriden = ctx.getInfo().getElementUtilities().getOverriddenMethod(mel);
                if (overriden != null && overriden.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            }
            ++methodCount;
        }
        if (methodCount <= limit) {
            return null;
        }
        if (anon) {
            CompilationInfo info = ctx.getInfo();
            SourcePositions sourcePositions = info.getTrees().getSourcePositions();
            long start = sourcePositions.getStartPosition(info.getCompilationUnit(), path.getParentPath().getLeaf());
            long mstart = sourcePositions.getStartPosition(info.getCompilationUnit(), path.getLeaf());
            return ErrorDescriptionFactory.forSpan((HintContext)ctx, (int)((int)start), (int)((int)mstart), (String)Bundle.TEXT_AnonClassManyMethods(methodCount), (Fix[])new Fix[0]);
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)path, (String)Bundle.TEXT_ClassManyMethods(clazz.getSimpleName().toString(), methodCount), (Fix[])new Fix[0]);
    }

    public static ErrorDescription tooManyFields(HintContext ctx) {
        ClassTree clazz = (ClassTree)ctx.getPath().getLeaf();
        boolean ignoreConstants = ctx.getPreferences().getBoolean(OPTION_CLASS_FIELDS_IGNORE_CONSTANTS, true);
        int fieldCount = 0;
        for (Tree tree : clazz.getMembers()) {
            if (tree.getKind() != Tree.Kind.VARIABLE) continue;
            if (ignoreConstants) {
                TreePath fieldPath = new TreePath(ctx.getPath(), tree);
                if (ClassMetrics.isConstant(ctx.getInfo(), fieldPath)) continue;
            }
            ++fieldCount;
        }
        int limit = ctx.getPreferences().getInt(OPTION_CLASS_FIELDS_LIMIT, 10);
        if (fieldCount > limit) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_ClassManyFields(clazz.getSimpleName().toString(), fieldCount), (Fix[])new Fix[0]);
        }
        return null;
    }

    static boolean isSimpleSetter(CompilationInfo info, TreePath methodPath) {
        MethodTree method = (MethodTree)methodPath.getLeaf();
        Name mn = method.getName();
        if (mn.length() < 4 || !mn.subSequence(0, 3).toString().equals("set")) {
            return false;
        }
        if (method.getParameters().size() != 1) {
            return false;
        }
        TypeMirror retType = info.getTrees().getTypeMirror(new TreePath(methodPath, method.getReturnType()));
        if (retType.getKind() != TypeKind.VOID) {
            return false;
        }
        if (method.getBody() == null || method.getBody().getStatements().size() != 1) {
            return false;
        }
        StatementTree st = method.getBody().getStatements().get(0);
        if (st.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            return false;
        }
        ExpressionTree stEx = ((ExpressionStatementTree)st).getExpression();
        if (stEx.getKind() != Tree.Kind.ASSIGNMENT) {
            return false;
        }
        Element e = info.getTrees().getElement(new TreePath(new TreePath(new TreePath(new TreePath(methodPath, method.getBody()), st), stEx), ((AssignmentTree)stEx).getVariable()));
        if (!ClassMetrics.isFieldOfThis(info, e, methodPath)) {
            return false;
        }
        ExpressionTree expr = ((AssignmentTree)stEx).getExpression();
        TreePath exprPath = new TreePath(new TreePath(new TreePath(methodPath, method.getBody()), st), expr);
        boolean unwrap = true;
        while (unwrap) {
            switch (expr.getKind()) {
                case PARENTHESIZED: {
                    expr = ((ParenthesizedTree)expr).getExpression();
                    break;
                }
                case TYPE_CAST: {
                    expr = ((TypeCastTree)expr).getExpression();
                    break;
                }
                default: {
                    unwrap = false;
                }
            }
            if (!unwrap) continue;
            exprPath = new TreePath(exprPath, expr);
        }
        Name paramName = method.getParameters().get(0).getName();
        return expr.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)expr).getName().equals(paramName);
    }

    private static boolean isFieldOfThis(CompilationInfo info, Element e, TreePath methodPath) {
        if (e == null || e.getKind() != ElementKind.FIELD) {
            return false;
        }
        if (e.getEnclosingElement() == null || e.getEnclosingElement().getKind() != ElementKind.CLASS) {
            return false;
        }
        TypeMirror methodDeclaringType = info.getTrees().getElement(methodPath).getEnclosingElement().asType();
        TypeMirror fieldParent = e.getEnclosingElement().asType();
        return info.getTypes().isSubtype(methodDeclaringType, fieldParent);
    }

    static boolean isSimpleGetter(CompilationInfo info, TreePath methodPath) {
        MethodTree method = (MethodTree)methodPath.getLeaf();
        Name mn = method.getName();
        boolean boolProp = false;
        if (mn.length() < 3) {
            return false;
        }
        if (mn.subSequence(0, 2).equals("is")) {
            boolProp = true;
            String propName = mn.subSequence(2, mn.length()).toString();
        } else if (mn.length() < 4 || !mn.subSequence(0, 3).toString().equals("get")) {
            return false;
        }
        if (!method.getParameters().isEmpty()) {
            return false;
        }
        if (method.getBody() == null) {
            return false;
        }
        List<? extends StatementTree> stmts = method.getBody().getStatements();
        if (stmts.size() != 1) {
            return false;
        }
        StatementTree ret = stmts.get(0);
        if (ret.getKind() != Tree.Kind.RETURN) {
            return false;
        }
        ExpressionTree expr = ((ReturnTree)ret).getExpression();
        TreePath exprPath = new TreePath(new TreePath(new TreePath(methodPath, method.getBody()), ret), expr);
        boolean unwrap = true;
        while (unwrap) {
            switch (expr.getKind()) {
                case PARENTHESIZED: {
                    expr = ((ParenthesizedTree)expr).getExpression();
                    break;
                }
                case TYPE_CAST: {
                    expr = ((TypeCastTree)expr).getExpression();
                    break;
                }
                default: {
                    unwrap = false;
                }
            }
            if (!unwrap) continue;
            exprPath = new TreePath(exprPath, expr);
        }
        if (expr.getKind() == Tree.Kind.MEMBER_SELECT) {
            ExpressionTree selector = ((MemberSelectTree)expr).getExpression();
            if (selector.getKind() != Tree.Kind.IDENTIFIER) {
                return false;
            }
            if (!((IdentifierTree)selector).getName().contentEquals("this")) {
                return false;
            }
            Name fieldName = ((MemberSelectTree)expr).getIdentifier();
        } else if (expr.getKind() == Tree.Kind.IDENTIFIER) {
            Name name = ((IdentifierTree)expr).getName();
        }
        Element e = info.getTrees().getElement(exprPath);
        return ClassMetrics.isFieldOfThis(info, e, methodPath);
    }

    static boolean isConstant(CompilationInfo info, TreePath fieldPath) {
        String sn;
        VariableTree var = (VariableTree)fieldPath.getLeaf();
        if (!var.getModifiers().getFlags().containsAll(CONSTANT_MODS)) {
            return false;
        }
        TypeMirror tm = info.getTrees().getTypeMirror(fieldPath);
        switch (tm.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
            case DECLARED: {
                break;
            }
            default: {
                return false;
            }
        }
        Element e = info.getTypes().asElement(tm);
        if (!(e instanceof TypeElement)) {
            return false;
        }
        String fqn = ((TypeElement)e).getQualifiedName().toString();
        if (!fqn.startsWith("java.lang.")) {
            return false;
        }
        switch (sn = ((TypeElement)e).getSimpleName().toString()) {
            case "Boolean": 
            case "Byte": 
            case "Char": 
            case "Double": 
            case "Float": 
            case "Integer": 
            case "Long": 
            case "Short": 
            case "String": 
            case "Class": {
                return true;
            }
        }
        return false;
    }
}

