/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.lib.profiler.server.ProfilerServer;

public class ProfilerActivate15 {
    public static void agentmain(String agentArgs, Instrumentation inst) {
        ProfilerActivate15.activate(agentArgs, inst, 0);
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        ProfilerActivate15.activate(agentArgs, inst, 1);
    }

    private static File getArchiveFile(URL url) {
        String path;
        int index;
        String protocol = url.getProtocol();
        if ("jar".equals(protocol) && (index = (path = url.getPath()).indexOf("!/")) >= 0) {
            try {
                return new File(new URI(path.substring(0, index)));
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(url.toString());
            }
        }
        throw new IllegalArgumentException(url.toString());
    }

    private static void activate(String agentArgs, Instrumentation inst, int activateCode) {
        URL classUrl = ProfilerActivate15.getSelfClassUrl();
        File jar = ProfilerActivate15.getArchiveFile(classUrl);
        String fullJFluidPath = jar.getParent();
        if (agentArgs == null || agentArgs.length() == 0) {
            ProfilerServer.loadNativeLibrary((String)fullJFluidPath, (boolean)false);
            return;
        }
        int timeOut = 0;
        int commaPos = agentArgs.indexOf(44);
        if (commaPos != -1) {
            String timeOutStr = agentArgs.substring(commaPos + 1);
            try {
                timeOut = Integer.parseInt(timeOutStr);
            }
            catch (NumberFormatException ex) {
                System.err.println("*** Profiler Engine: invalid timeout number specified to premain(): " + timeOutStr);
                System.exit(-1);
            }
            agentArgs = agentArgs.substring(0, commaPos);
        }
        String portStr = agentArgs;
        int portNo = 0;
        try {
            portNo = Integer.parseInt(portStr);
        }
        catch (NumberFormatException ex) {
            System.err.println("*** Profiler Engine: invalid port number specified to premain(): " + portStr);
            System.exit(-1);
        }
        ProfilerServer.loadNativeLibrary((String)fullJFluidPath, (boolean)false);
        ProfilerServer.activate((String)fullJFluidPath, (int)portNo, (int)activateCode, (int)timeOut);
    }

    private static URL getSelfClassUrl() {
        String SELF_CLASS_NAME = "org/netbeans/lib/profiler/server/ProfilerActivate15.class";
        URL classUrl = ClassLoader.getSystemClassLoader().getResource(SELF_CLASS_NAME);
        if (classUrl == null) {
            classUrl = Thread.currentThread().getContextClassLoader().getResource(SELF_CLASS_NAME);
        }
        return classUrl;
    }
}

