/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.branch;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.libs.git.GitCherryPickResult;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.branch.Bundle;
import org.netbeans.modules.git.ui.branch.CherryPick;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsExecutor;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.status.StatusAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.git.utils.ResultProcessor;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class CherryPickAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(CherryPickAction.class.getName());

    public void cherryPick(File repository, String preselectedRevision) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refresh();
        GitRepositoryState state = info.getRepositoryState();
        boolean interrupted = this.isInterrupted(repository, state);
        if (state == GitRepositoryState.SAFE && !interrupted) {
            CherryPick cherryPick = new CherryPick(repository, preselectedRevision);
            if (cherryPick.showDialog()) {
                this.runCherryPick(repository, GitClient.CherryPickOperation.BEGIN, new String[]{cherryPick.getRevision()});
            }
        } else if (interrupted) {
            Object[] objectArray;
            JButton btnContinue = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)btnContinue, (String)Bundle.CTL_CherryPickAction_continueButton_text());
            btnContinue.setToolTipText(Bundle.CTL_CherryPickAction_continueButton_TTtext());
            JButton btnAbort = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)btnAbort, (String)Bundle.CTL_CherryPickAction_abortButton_text());
            btnAbort.setToolTipText(Bundle.CTL_CherryPickAction_abortButton_TTtext());
            JButton btnQuit = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)btnQuit, (String)Bundle.CTL_CherryPickAction_quitButton_text());
            btnQuit.setToolTipText(Bundle.CTL_CherryPickAction_quitButton_TTtext());
            HashMap<JButton, GitClient.CherryPickOperation> operations = new HashMap<JButton, GitClient.CherryPickOperation>();
            operations.put(btnContinue, GitClient.CherryPickOperation.CONTINUE);
            operations.put(btnQuit, GitClient.CherryPickOperation.QUIT);
            operations.put(btnAbort, GitClient.CherryPickOperation.ABORT);
            if (interrupted) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = btnContinue;
                objectArray2[1] = btnAbort;
                objectArray2[2] = btnQuit;
                objectArray = objectArray2;
                objectArray2[3] = NotifyDescriptor.CANCEL_OPTION;
            } else {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = btnContinue;
                objectArray3[1] = btnAbort;
                objectArray = objectArray3;
                objectArray3[2] = NotifyDescriptor.CANCEL_OPTION;
            }
            Object[] options = objectArray;
            Object value = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)(interrupted ? Bundle.MSG_CherryPick_cherryPickingScheduledState_text(repository.getName()) : Bundle.MSG_CherryPick_cherryPickingState_text(repository.getName())), Bundle.LBL_CherryPick_cherryPickingState_title(), 1, 3, options, (Object)btnContinue));
            GitClient.CherryPickOperation op = (GitClient.CherryPickOperation)operations.get(value);
            if (op != null) {
                this.runCherryPick(repository, op, null);
            }
        } else {
            GitClientExceptionHandler.annotate(Bundle.MSG_CherryPickAction_notAllowed(state));
        }
    }

    public void finish(File repository) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refresh();
        if (this.isInterrupted(repository, info.getRepositoryState())) {
            this.cherryPick(repository, null);
        }
    }

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.cherryPick(repository, null);
    }

    private boolean isInterrupted(File repository, GitRepositoryState state) {
        if (state == GitRepositoryState.CHERRY_PICKING || state == GitRepositoryState.CHERRY_PICKING_RESOLVED) {
            return true;
        }
        File sequencer = new File(GitUtils.getGitFolderForRoot(repository), "sequencer");
        String[] fileNames = sequencer.list();
        return fileNames != null && Arrays.asList(fileNames).contains("todo");
    }

    private void runCherryPick(final File repository, final GitClient.CherryPickOperation op, final String[] revisions) {
        GitProgressSupport supp = new GitProgressSupport(this){
            final /* synthetic */ CherryPickAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void perform() {
                try {
                    GitUtils.runWithoutIndexing(new Callable<Void>(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public Void call() throws Exception {
                            GitClient client = this.this$1.getClient();
                            CherryPickResultProcessor rp = new CherryPickResultProcessor(client, repository, this.this$1.getProgressSupport());
                            GitClient.CherryPickOperation nextAction = op;
                            while (nextAction != null && !this.this$1.isCanceled()) {
                                GitCherryPickResult result = client.cherryPick(nextAction, revisions, this.this$1.getProgressMonitor());
                                rp.processResult(result, nextAction);
                                nextAction = rp.getNextAction();
                            }
                            return null;
                        }
                    }, new File[0]);
                }
                catch (GitException ex) {
                    try {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    catch (Throwable throwable) {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                        GitUtils.headChanged(repository);
                        throw throwable;
                    }
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                    GitUtils.headChanged(repository);
                }
                this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                GitUtils.headChanged(repository);
            }

            private GitProgressSupport getProgressSupport() {
                return this;
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.MSG_CherryPickAction_progress());
    }

    public static class CherryPickResultProcessor
    extends ResultProcessor {
        private final OutputLogger logger;
        private GitClient.CherryPickOperation nextAction;
        private final GitProgressSupport supp;

        public CherryPickResultProcessor(GitClient client, File repository, GitProgressSupport supp) {
            super(client, repository, "HEAD", supp.getProgressMonitor());
            this.logger = supp.getLogger();
            this.supp = supp;
        }

        public void processResult(GitCherryPickResult result, GitClient.CherryPickOperation currentOp) {
            this.nextAction = null;
            StringBuilder sb = new StringBuilder(Bundle.MSG_CherryPickAction_result(result.getCherryPickStatus().toString()));
            GitRevisionInfo info = result.getCurrentHead();
            switch (result.getCherryPickStatus()) {
                case ABORTED: {
                    sb.append(Bundle.MSG_CherryPickAction_result_aborted(info.getRevision()));
                    GitUtils.printInfo(sb, info);
                    break;
                }
                case FAILED: {
                    sb.append(Bundle.MSG_CherryPickAction_result_failed());
                    this.printConflicts(this.logger, sb, result.getFailures());
                    try {
                        if (this.resolveLocalChanges(result.getFailures().toArray(new File[result.getFailures().size()]))) {
                            this.nextAction = GitClient.CherryPickOperation.CONTINUE;
                            break;
                        }
                        if (currentOp != GitClient.CherryPickOperation.BEGIN) break;
                        this.nextAction = GitClient.CherryPickOperation.QUIT;
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    break;
                }
                case CONFLICTING: {
                    sb.append(Bundle.MSG_CherryPickAction_result_conflict());
                    this.printConflicts(this.logger, sb, result.getConflicts());
                    this.nextAction = this.resolveCherryPickConflicts(result.getConflicts());
                    break;
                }
                case OK: {
                    sb.append(Bundle.MSG_CherryPickAction_result_ok());
                    break;
                }
                case UNCOMMITTED: {
                    this.askForCommit();
                }
            }
            for (GitRevisionInfo commit : result.getCherryPickedCommits()) {
                GitUtils.printInfo(sb, commit);
            }
            if (sb.length() > 0) {
                this.logger.outputLine(sb.toString());
            }
        }

        public GitClient.CherryPickOperation getNextAction() {
            return this.nextAction;
        }

        private GitClient.CherryPickOperation resolveCherryPickConflicts(Collection<File> conflicts) {
            GitClient.CherryPickOperation action = null;
            JButton abort = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)abort, (String)Bundle.LBL_CherryPickResultProcessor_abortButton_text());
            abort.setToolTipText(Bundle.LBL_CherryPickResultProcessor_abortButton_TTtext());
            JButton resolve = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)resolve, (String)Bundle.LBL_CherryPickResultProcessor_resolveButton_text());
            resolve.setToolTipText(Bundle.LBL_CherryPickResultProcessor_resolveButton_TTtext());
            JButton review = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)review, (String)Bundle.LBL_CherryPickResultProcessor_reviewButton_text());
            review.setToolTipText(Bundle.LBL_CherryPickResultProcessor_reviewButton_TTtext());
            Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_CherryPickResultProcessor_resolveConflicts(), Bundle.LBL_CherryPickResultProcessor_resolveConflicts(), 2, 3, new Object[]{resolve, review, abort, NotifyDescriptor.CANCEL_OPTION}, (Object)resolve));
            if (o == review) {
                this.openInVersioningView(conflicts);
            } else if (o == resolve) {
                ResolveConflictsExecutor executor = new ResolveConflictsExecutor(conflicts.toArray(new File[0]));
                executor.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, Bundle.MSG_CherryPick_resolving());
            } else if (o == abort) {
                action = GitClient.CherryPickOperation.ABORT;
            }
            return action;
        }

        private void askForCommit() {
            JButton commit = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)commit, (String)Bundle.LBL_CherryPickResultProcessor_commit_commitButton_text());
            commit.setToolTipText(Bundle.LBL_CherryPickResultProcessor_commit_commitButton_TTtext());
            JButton review = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)review, (String)Bundle.LBL_CherryPickResultProcessor_commit_reviewButton_text());
            review.setToolTipText(Bundle.LBL_CherryPickResultProcessor_commit_reviewButton_TTtext());
            Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_CherryPickResultProcessor_commit(), Bundle.LBL_CherryPickResultProcessor_commit(), 2, 3, new Object[]{commit, review, NotifyDescriptor.CANCEL_OPTION}, (Object)commit));
            final VCSContext context = GitUtils.getContextForFile(this.repository);
            if (o == commit) {
                ((CommitAction)SystemAction.get(CommitAction.class)).performAction(context);
            } else if (o == review) {
                Mutex.EVENT.readAccess(new Runnable(){
                    final /* synthetic */ CherryPickResultProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        ((StatusAction)SystemAction.get(StatusAction.class)).performContextAction(context);
                    }
                });
            }
        }
    }
}

