/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table.celleditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.db.dataview.table.ResultSetTableCellEditor;
import org.openide.windows.WindowManager;

public class StringTableCellEditor
extends ResultSetTableCellEditor
implements TableCellEditor,
ActionListener {
    private final JButton customEditorButton = new JButton("...");
    private JTextComponent tc;
    private TableModel tableModel;
    private String columnName;
    private int modelRow;
    private int modelColumn;

    public StringTableCellEditor(JTextField textField) {
        super(textField);
        this.customEditorButton.addActionListener(this);
        this.customEditorButton.setFocusable(false);
        this.customEditorButton.setFocusPainted(false);
        this.customEditorButton.setMargin(new Insets(0, 0, 0, 0));
        this.customEditorButton.setPreferredSize(new Dimension(20, 10));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        final JComponent c = (JComponent)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.tableModel = table.getModel();
        this.columnName = table.getColumnName(column);
        this.modelRow = table.convertRowIndexToModel(row);
        this.modelColumn = table.convertColumnIndexToModel(column);
        this.tc = c instanceof JTextComponent ? (JTextComponent)c : null;
        JPanel panel = new JPanel(this, new BorderLayout()){
            final /* synthetic */ StringTableCellEditor this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void addNotify() {
                super.addNotify();
                c.requestFocus();
            }
        };
        panel.add(c);
        if (suppressEditorBorder) {
            c.setBorder(BorderFactory.createEmptyBorder());
        }
        panel.add((Component)this.customEditorButton, "East");
        panel.revalidate();
        panel.repaint();
        return panel;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        super.cancelCellEditing();
        this.editCell();
    }

    private void editCell() {
        assert (this.tc != null) : "String TableCellEditor called without a TextComponent";
        JTextArea textArea = new JTextArea(20, 80);
        textArea.setDropTarget(null);
        boolean editable = this.tableModel.isCellEditable(this.modelRow, this.modelColumn);
        textArea.setText(this.tc.getText());
        textArea.setCaretPosition(0);
        textArea.setEditable(editable);
        JScrollPane pane = new JScrollPane(textArea);
        pane.addHierarchyListener(new MakeResizableListener(pane));
        Frame parent = WindowManager.getDefault().getMainWindow();
        if (editable) {
            int result = JOptionPane.showOptionDialog(parent, pane, this.columnName, 2, -1, null, null, null);
            if (result == 0) {
                this.tableModel.setValueAt(textArea.getText(), this.modelRow, this.modelColumn);
            }
        } else {
            JOptionPane.showMessageDialog(parent, pane, this.columnName, -1, null);
        }
    }

    static class MakeResizableListener
    implements HierarchyListener {
        private Component pane;

        public MakeResizableListener(Component pane) {
            this.pane = pane;
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(this.pane);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        }
    }
}

