/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.caret;

import java.awt.Point;
import java.util.logging.Logger;
import javax.swing.text.Position;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.caret.CaretItem;

public final class CaretInfo {
    private static final Logger LOG = Logger.getLogger(CaretInfo.class.getName());
    private final CaretItem caretItem;
    private final Position dotPos;
    private final Position.Bias dotBias;
    private final Position markPos;
    private final Position.Bias markBias;
    private final Point magicCaretPosition;

    CaretInfo(CaretItem caretItem) {
        this.caretItem = caretItem;
        this.dotPos = caretItem.getDotPosition();
        this.dotBias = caretItem.getDotBias();
        this.markPos = caretItem.getMarkPosition();
        this.markBias = caretItem.getMarkBias();
        this.magicCaretPosition = caretItem.getMagicCaretPosition();
    }

    @CheckForNull
    public Position getDotPosition() {
        return this.dotPos;
    }

    @NonNull
    public Position.Bias getDotBias() {
        return this.dotBias;
    }

    @CheckForNull
    public Position getMarkPosition() {
        return this.markPos;
    }

    @NonNull
    public Position.Bias getMarkBias() {
        return this.markBias;
    }

    public int getDot() {
        return this.dotPos != null ? this.dotPos.getOffset() : 0;
    }

    public int getMark() {
        return this.markPos != null ? this.markPos.getOffset() : this.getDot();
    }

    public boolean isSelection() {
        return this.dotPos != null && this.markPos != null && this.markPos != this.dotPos && this.dotPos.getOffset() != this.markPos.getOffset();
    }

    public boolean isSelectionShowing() {
        return this.caretItem.editorCaret().isSelectionVisible() && this.isSelection();
    }

    public int getSelectionStart() {
        return Math.min(this.getDot(), this.getMark());
    }

    public int getSelectionEnd() {
        return Math.max(this.getDot(), this.getMark());
    }

    @CheckForNull
    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    CaretItem getCaretItem() {
        return this.caretItem;
    }

    public String toString() {
        return "dotPos=" + this.dotPos + ", markPos=" + this.markPos + ", magicCaretPosition=" + this.magicCaretPosition + "\n  caretItem=" + this.caretItem;
    }
}

