/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.network.ui;

import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class NetworkErrorPanel
extends JPanel {
    private static final long serialVersionUID = 783521567875L;
    public static final int MAX_REQUEST_LENGTH = 80;
    private final List<String> failedRequests;
    private JScrollPane infoScrollPane;
    private JTextPane infoTextPane;

    public NetworkErrorPanel(List<String> failedRequests) {
        this.failedRequests = failedRequests;
        this.initComponents();
        this.init();
    }

    private void init() {
        String text = this.infoTextPane.getText();
        this.infoTextPane.setText(text.replace("%FAILED_REQUESTS%", NetworkErrorPanel.joinRequests(this.failedRequests)));
        this.infoTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
                }
            }
        });
    }

    static String joinRequests(List<String> failedRequests) {
        StringBuilder sb = new StringBuilder(200);
        for (String request : failedRequests) {
            if (request == null) {
                throw new NullPointerException("Request cannot be null");
            }
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append(NetworkErrorPanel.decorateRequest(request));
        }
        return sb.toString();
    }

    static String decorateRequest(String request) {
        String original = request;
        if (request.length() > 80) {
            request = request.substring(0, 80) + "...";
        }
        if (request.startsWith("http://") || request.startsWith("https://")) {
            return "<a href=\"" + original + "\">" + request + "</a>";
        }
        return request;
    }

    private void initComponents() {
        this.infoScrollPane = new JScrollPane();
        this.infoTextPane = new JTextPane();
        this.infoScrollPane.setBorder(null);
        this.infoTextPane.setEditable(false);
        this.infoTextPane.setBorder(null);
        this.infoTextPane.setContentType("text/html");
        this.infoTextPane.setText(NbBundle.getMessage(NetworkErrorPanel.class, (String)"NetworkErrorPanel.infoTextPane.text"));
        this.infoTextPane.setOpaque(false);
        this.infoScrollPane.setViewportView(this.infoTextPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.infoScrollPane).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.infoScrollPane).addContainerGap()));
    }
}

