/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RefreshWsDialog
extends JPanel {
    static final String CLOSE = "0";
    static final String DO_NOTHING = "1";
    static final String DOWNLOAD_WSDL = "2";
    static final String REGENERATE_IMPL_CLASS = "3";
    static final String DO_ALL = "4";
    private String implClass;
    private String url;
    private boolean downloadWsdl;
    private JCheckBox downloadWsdlCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField jTextField1;
    private JCheckBox regenerateCheckBox;

    private RefreshWsDialog(boolean downloadWsdl, String implClass, String url) {
        this.downloadWsdl = downloadWsdl;
        this.implClass = implClass;
        this.url = url;
        this.initComponents();
        if (!downloadWsdl) {
            this.downloadWsdlCheckBox.setVisible(false);
            this.jLabel1.setVisible(false);
            this.jTextField1.setVisible(false);
        } else {
            this.jTextField1.setText(url);
            this.downloadWsdlCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        RefreshWsDialog.this.jTextField1.setEditable(true);
                    } else {
                        RefreshWsDialog.this.jTextField1.setEditable(false);
                    }
                }
            });
        }
    }

    public static String open(boolean downloadWsdl, String implClass, String url) {
        String title = NbBundle.getMessage(RefreshWsDialog.class, (String)"MSG_ConfirmServiceRefresh");
        RefreshWsDialog refreshDialog = new RefreshWsDialog(downloadWsdl, implClass, url);
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)refreshDialog, title, 0);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (result.equals(NotifyDescriptor.CLOSED_OPTION)) {
            return CLOSE;
        }
        if (result.equals(NotifyDescriptor.NO_OPTION)) {
            return CLOSE;
        }
        if (refreshDialog.downloadWsdl() && refreshDialog.regenerate()) {
            return DO_ALL + refreshDialog.getWsdlUrl();
        }
        if (refreshDialog.downloadWsdl()) {
            return DOWNLOAD_WSDL + refreshDialog.getWsdlUrl();
        }
        if (refreshDialog.regenerate()) {
            return REGENERATE_IMPL_CLASS;
        }
        return DO_NOTHING;
    }

    public static String openWithOKButtonOnly(boolean downloadWsdl, String implClass, String url) {
        RefreshWsDialog delDialog = new RefreshWsDialog(downloadWsdl, implClass, url);
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)delDialog, 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (delDialog.regenerate()) {
            return REGENERATE_IMPL_CLASS;
        }
        return DO_NOTHING;
    }

    private boolean downloadWsdl() {
        if (!this.downloadWsdl) {
            return false;
        }
        return this.downloadWsdlCheckBox.isSelected();
    }

    private boolean regenerate() {
        return this.regenerateCheckBox.isSelected();
    }

    private void initComponents() {
        this.downloadWsdlCheckBox = new JCheckBox();
        this.regenerateCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.downloadWsdlCheckBox, (String)NbBundle.getMessage(RefreshWsDialog.class, (String)"MSG_DownloadWsdl", (Object[])new Object[]{this.url}));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.downloadWsdlCheckBox, gridBagConstraints);
        this.regenerateCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.regenerateCheckBox, (String)NbBundle.getMessage(RefreshWsDialog.class, (String)"MSG_RegenerateImplClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.regenerateCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RefreshWsDialog.class, (String)"HINT_DownloadWsdl"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RefreshWsDialog.class, (String)"HINT_RegenerateImplClass", (Object[])new Object[]{this.implClass + ".java.old"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RefreshWsDialog.class, (String)"HINT_RefreshService"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextField1.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 22, 0, 22);
        this.add((Component)this.jTextField1, gridBagConstraints);
    }

    private String getWsdlUrl() {
        return this.jTextField1.getText().trim();
    }
}

