/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.core.jaxws.actions.ConvertToRestCookie;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsRefreshAction;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class ConvertToRestAction
extends CookieAction {
    protected int mode() {
        return 8;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 1) {
            Node node = activatedNodes[0];
            Service service = (Service)node.getLookup().lookup(Service.class);
            FileObject implClass = (FileObject)node.getLookup().lookup(FileObject.class);
            if (implClass == null) {
                return false;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)implClass);
            if (project == null || project.getLookup().lookup(RestSupport.class) == null) {
                return false;
            }
            if (service != null) {
                return !service.isUseProvider();
            }
        }
        return super.enable(activatedNodes);
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{ConvertToRestCookie.class};
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        Node node;
        ConvertToRestCookie cookie;
        if (activatedNodes.length == 1 && (cookie = (ConvertToRestCookie)(node = activatedNodes[0]).getCookie(ConvertToRestCookie.class)) != null) {
            cookie.convertToRest();
            Object[] params = new Object[]{"JAX-WS", "CONVERT TO REST"};
            LogUtils.logWsAction((Object[])params);
        }
    }

    public String getName() {
        return NbBundle.getMessage(JaxWsRefreshAction.class, (String)"LBL_ConvertToRestAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

