/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeText;

public class TreeTextCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = 6854917766750212771L;
    private JTextArea dataTextArea;
    private JPanel dataPanel;
    private JScrollPane dataScroll;

    public TreeTextCustomizer() {
        this.initComponents();
        this.initAccessibility();
    }

    protected final TreeText getText() {
        return (TreeText)this.getTreeObject();
    }

    @Override
    protected final void safePropertyChange(PropertyChangeEvent pche) {
        super.safePropertyChange(pche);
        if (pche.getPropertyName().equals("data")) {
            this.updateDataComponent();
        }
    }

    protected final void updateTextData() {
        try {
            this.getText().setData(this.dataTextArea.getText());
        }
        catch (TreeException exc) {
            this.updateDataComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateDataComponent() {
        this.dataTextArea.setText(this.getText().getData());
    }

    @Override
    protected final void initComponentValues() {
        this.updateDataComponent();
    }

    @Override
    protected void updateReadOnlyStatus(boolean editable) {
        this.dataTextArea.setEditable(editable);
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.dataScroll = new JScrollPane();
        this.dataTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(350, 230));
        this.dataPanel.setLayout(new BorderLayout());
        this.dataTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TreeTextCustomizer.this.dataTextAreaFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                TreeTextCustomizer.this.dataTextAreaFocusLost(evt);
            }
        });
        this.dataTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TreeTextCustomizer.this.dataTextAreaKeyPressed(evt);
            }
        });
        this.dataScroll.setViewportView(this.dataTextArea);
        this.dataPanel.add((Component)this.dataScroll, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.dataPanel, gridBagConstraints);
    }

    private void dataTextAreaFocusGained(FocusEvent evt) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.dataTextArea.selectAll();
        }
    }

    private void dataTextAreaKeyPressed(KeyEvent evt) {
        if (TreeTextCustomizer.applyKeyPressed(evt)) {
            this.updateTextData();
        }
    }

    private void dataTextAreaFocusLost(FocusEvent evt) {
        this.updateTextData();
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeTextCustomizer"));
        this.dataTextArea.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_dataPanel3"));
        this.dataTextArea.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_dataPanel3"));
    }
}

