/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames.models;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.frames.models.DebuggingTruffleTreeModel;
import org.netbeans.modules.debugger.jpda.truffle.frames.models.TruffleDVFrame;
import org.netbeans.modules.debugger.jpda.truffle.options.TruffleOptions;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebuggingViewSupportImpl;
import org.netbeans.modules.debugger.jpda.ui.debugging.JPDADVFrame;
import org.netbeans.modules.debugger.jpda.ui.debugging.JPDADVThread;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.DebuggingView;

public class DebuggingViewTruffleSupport
extends DebuggingViewSupportImpl {
    public DebuggingViewTruffleSupport(ContextProvider lookupProvider) {
        super(lookupProvider);
    }

    protected int getFrameCount(JPDADVThread thread) {
        CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo((JPDAThread)thread.getKey());
        if (currentPCInfo != null) {
            return this.getFrames(thread, 0, Integer.MAX_VALUE).size();
        }
        return super.getFrameCount(thread);
    }

    protected List<DebuggingView.DVFrame> getFrames(JPDADVThread thread, int from, int to) {
        List<DebuggingView.DVFrame> frames = super.getFrames(thread, 0, Integer.MAX_VALUE);
        if (frames.isEmpty()) {
            return frames;
        }
        JPDAThreadImpl jt = thread.getKey();
        CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentGuestPCInfo((JPDAThread)jt);
        boolean inGuest = DebuggingViewTruffleSupport.isInGuest((DebuggingView.DVFrame)frames.get(0));
        boolean haveTopHostFrames = false;
        if (currentPCInfo == null) {
            currentPCInfo = inGuest ? TruffleAccess.getCurrentSuspendHereInfo((JPDAThread)jt) : TruffleAccess.getSuspendHere((JPDAThread)jt);
            haveTopHostFrames = true;
        }
        if (currentPCInfo != null) {
            boolean showInternalFrames = TruffleOptions.isLanguageDeveloperMode();
            TruffleStackFrame[] stackFrames = currentPCInfo.getStack().getStackFrames(showInternalFrames);
            frames = inGuest && !currentPCInfo.getStack().hasJavaFrames() ? DebuggingTruffleTreeModel.filterAndAppend(thread, frames, stackFrames, currentPCInfo.getTopFrame()) : DebuggingTruffleTreeModel.mergeFrames(thread, frames, stackFrames, currentPCInfo.getTopFrame(), haveTopHostFrames);
        }
        if (from >= frames.size()) {
            return Collections.emptyList();
        }
        to = Math.min(to, frames.size());
        return frames.subList(from, to);
    }

    private static boolean isInGuest(DebuggingView.DVFrame child) {
        CallStackFrame csf = ((JPDADVFrame)child).getCallStackFrame();
        return "org.netbeans.modules.debugger.jpda.backend.truffle.JPDATruffleAccessor".equals(csf.getClassName());
    }

    public String getDisplayName(DebuggingView.DVFrame frame) {
        if (frame instanceof TruffleDVFrame) {
            return ((TruffleDVFrame)frame).getTruffleFrame().getDisplayName();
        }
        return super.getDisplayName(frame);
    }
}

