/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class CompilerOptionsQuery {
    private static final Lookup.Result<CompilerOptionsQueryImplementation> impls = Lookup.getDefault().lookupResult(CompilerOptionsQueryImplementation.class);

    private CompilerOptionsQuery() {
        throw new IllegalStateException("No instance allowed");
    }

    @NonNull
    public static Result getOptions(@NonNull FileObject file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        ArrayList<CompilerOptionsQueryImplementation.Result> collector = new ArrayList<CompilerOptionsQueryImplementation.Result>();
        for (CompilerOptionsQueryImplementation impl : impls.allInstances()) {
            CompilerOptionsQueryImplementation.Result res = impl.getOptions(file);
            if (res == null) continue;
            collector.add(res);
        }
        return collector.isEmpty() ? Result.EMPTY : new Result(collector);
    }

    public static final class Result {
        static final Result EMPTY = new Result(Collections.singletonList(new CompilerOptionsQueryImplementation.Result(){

            @Override
            public List<? extends String> getArguments() {
                return Collections.emptyList();
            }

            @Override
            public void addChangeListener(ChangeListener l) {
            }

            @Override
            public void removeChangeListener(ChangeListener l) {
            }
        }));
        private final List<? extends CompilerOptionsQueryImplementation.Result> results;
        private final ChangeSupport listeners;
        private ChangeListener changeListener;

        Result(@NonNull List<? extends CompilerOptionsQueryImplementation.Result> results) {
            Parameters.notNull((CharSequence)"results", results);
            this.results = results;
            this.listeners = new ChangeSupport((Object)this);
        }

        @NonNull
        public List<? extends String> getArguments() {
            ArrayList<? extends String> arguments = new ArrayList<String>();
            for (CompilerOptionsQueryImplementation.Result result : this.results) {
                List<? extends String> l = result.getArguments();
                assert (l != null);
                arguments.addAll(l);
            }
            return Collections.unmodifiableList(arguments);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.addChangeListener(listener);
            Result result = this;
            synchronized (result) {
                if (this.changeListener == null) {
                    this.changeListener = e -> this.listeners.fireChange();
                    for (CompilerOptionsQueryImplementation.Result result2 : this.results) {
                        result2.addChangeListener(WeakListeners.change((ChangeListener)this.changeListener, (Object)result2));
                    }
                }
            }
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.removeChangeListener(listener);
        }
    }
}

