/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.server.config;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.glassfish.tooling.server.config.JavaEEProfile;
import org.netbeans.modules.glassfish.tooling.server.config.JavaSet;
import org.netbeans.modules.glassfish.tooling.server.config.ModuleType;
import org.netbeans.modules.glassfish.tooling.server.parser.JavaEEModuleReader;
import org.netbeans.modules.glassfish.tooling.server.parser.JavaEEProfileCheckReader;
import org.netbeans.modules.glassfish.tooling.server.parser.JavaEEProfileReader;
import org.netbeans.modules.glassfish.tooling.utils.ServerUtils;

public class JavaEESet
extends JavaSet {
    private final List<JavaEEModuleReader.Module> modules;
    private final List<JavaEEProfileReader.Profile> profiles;
    private final Map<String, List<String>> checks;
    private final Map<String, Boolean> checkResults;

    public JavaEESet(List<JavaEEModuleReader.Module> modules, List<JavaEEProfileReader.Profile> profiles, List<JavaEEProfileCheckReader.Check> checks, String version) {
        super(version);
        this.modules = Collections.unmodifiableList(modules);
        this.profiles = Collections.unmodifiableList(profiles);
        HashMap<String, List<String>> checksMap = new HashMap<String, List<String>>(checks.size());
        for (JavaEEProfileCheckReader.Check check : checks) {
            checksMap.put(check.getName(), check.getFiles());
        }
        this.checks = Collections.unmodifiableMap(checksMap);
        this.checkResults = new HashMap<String, Boolean>(checks.size());
    }

    public List<JavaEEModuleReader.Module> getModules() {
        return this.modules;
    }

    public List<JavaEEProfileReader.Profile> getProfiles() {
        return this.profiles;
    }

    private boolean check(String name, File classpathHome) {
        if (name == null) {
            return true;
        }
        Boolean result = this.checkResults.get(name);
        if (result != null) {
            return result;
        }
        List<String> files = this.checks.get(name);
        boolean resultValue = true;
        if (files != null && !files.isEmpty()) {
            for (String fileName : files) {
                File file = ServerUtils.getJarName(classpathHome.getAbsolutePath(), fileName);
                if (file != null && file.exists()) continue;
                resultValue = false;
            }
        }
        this.checkResults.put(name, resultValue);
        return resultValue;
    }

    public void reset() {
        this.checkResults.clear();
    }

    public Set<ModuleType> moduleTypes(File classpathHome) {
        int size = this.modules != null ? this.modules.size() : 0;
        EnumSet<ModuleType> typesSet = EnumSet.noneOf(ModuleType.class);
        if (size > 0) {
            for (JavaEEModuleReader.Module module : this.modules) {
                ModuleType type = ModuleType.toValue(module.getType());
                if (type == null || !this.check(module.getCheck(), classpathHome)) continue;
                typesSet.add(type);
            }
        }
        return typesSet;
    }

    public Set<JavaEEProfile> profiles(File classpathHome) {
        int size = this.profiles != null ? this.profiles.size() : 0;
        EnumSet<JavaEEProfile> profilesSet = EnumSet.noneOf(JavaEEProfile.class);
        if (size > 0) {
            for (JavaEEProfileReader.Profile profileFromXML : this.profiles) {
                JavaEEProfile profile = JavaEEProfile.toValue(profileFromXML.getVersion(), profileFromXML.getType());
                if (profile == null || !this.check(profileFromXML.getCheck(), classpathHome)) continue;
                profilesSet.add(profile);
            }
        }
        return profilesSet;
    }
}

