/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.admin;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.logging.Level;
import org.netbeans.modules.glassfish.tooling.admin.Command;
import org.netbeans.modules.glassfish.tooling.admin.CommandGetProperty;
import org.netbeans.modules.glassfish.tooling.admin.ResultMap;
import org.netbeans.modules.glassfish.tooling.admin.RunnerHttp;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.logging.Logger;

public class RunnerHttpGetProperty
extends RunnerHttp {
    private static final Logger LOGGER = new Logger(RunnerHttpGetProperty.class);
    ResultMap<String, String> result;

    public RunnerHttpGetProperty(GlassFishServer server, Command command) {
        super(server, command, "pattern=" + ((CommandGetProperty)command).propertyPattern);
    }

    @Override
    protected ResultMap<String, String> createResult() {
        this.result = new ResultMap<String, String>();
        return this.result;
    }

    @Override
    protected boolean processResponse() {
        String METHOD = "processResponse";
        if (this.manifest == null) {
            LOGGER.log(Level.WARNING, "processResponse", "manifestNull", this.query);
            return false;
        }
        this.result.value = new HashMap();
        for (String encodedkey : this.manifest.getEntries().keySet()) {
            String key = "";
            try {
                if (null != encodedkey) {
                    key = encodedkey;
                    key = URLDecoder.decode(encodedkey, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException uee) {
                LOGGER.log(Level.INFO, "processResponse", "unsupportedEncoding", encodedkey);
                LOGGER.log(Level.INFO, "processResponse", "exceptionDetails", uee);
            }
            catch (IllegalArgumentException uee) {
                // empty catch block
            }
            int equalsIndex = key.indexOf(61);
            if (equalsIndex >= 0) {
                String keyPart = key.substring(0, equalsIndex);
                String valuePart = key.substring(equalsIndex + 1);
                try {
                    this.result.value.put(keyPart, valuePart);
                    this.result.value.put(keyPart, URLDecoder.decode(valuePart, "UTF-8"));
                    this.result.value.put(keyPart, URLDecoder.decode((String)this.result.value.get(keyPart), "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    LOGGER.log(Level.INFO, "processResponse", "unsupportedEncoding", this.result.value.get(keyPart));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.log(Level.INFO, "processResponse", "illegalArgument", new Object[]{valuePart, this.result.value.get(keyPart)});
                }
                continue;
            }
            LOGGER.log(Level.WARNING, "processResponse", "emptyString", key);
            this.result.value.put(key, "");
        }
        return true;
    }
}

