/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.admin;

import java.util.logging.Level;
import org.netbeans.modules.glassfish.tooling.admin.Command;
import org.netbeans.modules.glassfish.tooling.admin.CommandCreateInstance;
import org.netbeans.modules.glassfish.tooling.admin.CommandException;
import org.netbeans.modules.glassfish.tooling.admin.CommandTargetName;
import org.netbeans.modules.glassfish.tooling.admin.RunnerHttp;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.utils.Utils;

public class RunnerHttpCreateInstance
extends RunnerHttp {
    private static final Logger LOGGER = new Logger(RunnerHttpCreateInstance.class);
    private static final String DEFAULT_PARAM = "DEFAULT";
    private static final String NODE_PARAM = "node";
    private static final String CLUSTER_PARAM = "cluster";

    private static String query(Command command) {
        String cluster;
        String METHOD = "query";
        if (command instanceof CommandCreateInstance) {
            cluster = Utils.sanitizeName(((CommandCreateInstance)command).target);
            if (((CommandTargetName)command).name == null || ((CommandCreateInstance)command).node == null) {
                throw new CommandException(LOGGER.excMsg("query", "nullValue"));
            }
        } else {
            throw new CommandException(LOGGER.excMsg("query", "illegalInstance"));
        }
        String name = Utils.sanitizeName(((CommandCreateInstance)command).name);
        String node = Utils.sanitizeName(((CommandCreateInstance)command).node);
        StringBuilder sb = new StringBuilder(DEFAULT_PARAM.length() + 1 + name.length() + 1 + NODE_PARAM.length() + 1 + node.length() + (cluster != null ? 1 + CLUSTER_PARAM.length() + 1 + cluster.length() : 0));
        sb.append(DEFAULT_PARAM).append('=').append(name);
        sb.append('&');
        sb.append(NODE_PARAM).append('=').append(node);
        if (cluster != null) {
            sb.append('&');
            sb.append(CLUSTER_PARAM).append('=').append(cluster);
        }
        return sb.toString();
    }

    public RunnerHttpCreateInstance(GlassFishServer server, Command command) {
        super(server, command, RunnerHttpCreateInstance.query(command));
    }

    @Override
    protected boolean processResponse() {
        String METHOD = "processResponse";
        try {
            this.result.value = this.manifest.getMainAttributes().getValue("message");
            this.result.value = this.result.value.replace("%%%EOL%%%", "\n");
        }
        catch (IllegalArgumentException iae) {
            LOGGER.log(Level.WARNING, "processResponse", "illegalArgument", iae);
        }
        return this.result.value != null;
    }
}

