/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion.provider;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionContext;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedElement;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedField;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedMethod;
import org.netbeans.modules.groovy.editor.completion.AccessLevel;
import org.netbeans.modules.groovy.editor.completion.provider.CompletionAccessor;
import org.netbeans.modules.groovy.editor.java.JavaElementHandle;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.netbeans.modules.groovy.editor.spi.completion.CompletionProvider;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public final class GroovyElementsProvider
implements CompletionProvider {
    @Override
    public Map<MethodSignature, CompletionItem> getMethods(CompletionContext context) {
        GroovyIndex index = this.getIndex(context);
        HashMap<MethodSignature, CompletionItem> result = new HashMap<MethodSignature, CompletionItem>();
        boolean acc = GroovySettings.getInstance().isHonourAccessModifiers();
        if (index != null) {
            Set<IndexedMethod> methods = "".equals(context.getPrefix()) ? index.getMethods(".*", context.getTypeName(), QuerySupport.Kind.REGEXP) : index.getMethods(context.getPrefix(), context.getTypeName(), QuerySupport.Kind.PREFIX);
            for (IndexedMethod indexedMethod : methods) {
                if (acc && !this.accept(context.access, indexedMethod)) continue;
                JavaElementHandle jeh = null;
                if (indexedMethod.getFileObject().getMIMEType(new String[]{"text/x-java"}) != null) {
                    URL u = URLMapper.findURL((FileObject)indexedMethod.getFileObject(), (int)0);
                    jeh = new JavaElementHandle(u, indexedMethod.getName(), context.getTypeName(), ElementKind.METHOD, indexedMethod.getParameterTypes(), indexedMethod.getModifiers());
                }
                CompletionItem ci = CompletionAccessor.instance().createJavaMethod(context.getTypeName(), indexedMethod.getName(), indexedMethod.getParameters(), indexedMethod.getReturnType(), Utilities.gsfModifiersToModel(indexedMethod.getModifiers(), Modifier.PUBLIC), context.getAnchor(), false, context.isNameOnly());
                result.put(this.getMethodSignature(indexedMethod), CompletionAccessor.instance().assignHandle(ci, jeh));
            }
        }
        return result;
    }

    @Override
    public Map<MethodSignature, CompletionItem> getStaticMethods(CompletionContext context) {
        return Collections.emptyMap();
    }

    @Override
    public Map<FieldSignature, CompletionItem> getFields(CompletionContext context) {
        GroovyIndex index = this.getIndex(context);
        HashMap<FieldSignature, CompletionItem> result = new HashMap<FieldSignature, CompletionItem>();
        boolean acc = GroovySettings.getInstance().isHonourAccessModifiers();
        if (index != null) {
            Set<IndexedField> fields = "".equals(context.getPrefix()) ? index.getAllFields(context.getTypeName()) : index.getFields(context.getPrefix(), context.getTypeName(), QuerySupport.Kind.PREFIX);
            for (IndexedField indexedField : fields) {
                if (acc && !indexedField.isProperty() && !this.accept(context.access, indexedField)) continue;
                result.put(this.getFieldSignature(indexedField), new CompletionItem.FieldItem(indexedField.getTypeName(), indexedField.getName(), indexedField.getModifiers(), context.getAnchor()));
            }
        }
        return result;
    }

    @Override
    public Map<FieldSignature, CompletionItem> getStaticFields(CompletionContext context) {
        return Collections.emptyMap();
    }

    private GroovyIndex getIndex(CompletionContext context) {
        FileObject fo = context.getSourceFile();
        if (fo != null) {
            return GroovyIndex.get(QuerySupport.findRoots((FileObject)fo, Collections.singleton("classpath/source"), null, null));
        }
        return null;
    }

    private MethodSignature getMethodSignature(IndexedMethod method) {
        String[] parameters = method.getParameterTypes().toArray(new String[method.getParameterTypes().size()]);
        return new MethodSignature(method.getName(), parameters);
    }

    private FieldSignature getFieldSignature(IndexedField field) {
        return new FieldSignature(field.getName());
    }

    private boolean accept(Set<AccessLevel> levels, IndexedElement element) {
        for (AccessLevel accessLevel : levels) {
            if (!accessLevel.accept(element.getModifiers())) continue;
            return true;
        }
        return false;
    }
}

