/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.commandline;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.DetectedLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Premium;
import org.languagetool.bitext.BitextReader;
import org.languagetool.bitext.StringPair;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tools.ContextTools;
import org.languagetool.tools.RuleMatchesAsJsonSerializer;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public final class CommandLineTools {
    private static final int DEFAULT_CONTEXT_SIZE = 45;

    private CommandLineTools() {
    }

    public static void tagText(String contents, JLanguageTool lt) throws IOException {
        List sentences = lt.sentenceTokenize(contents);
        for (String sentence : sentences) {
            AnalyzedSentence analyzedText = lt.getAnalyzedSentence(sentence);
            System.out.println(analyzedText);
        }
    }

    public static int checkText(String contents, JLanguageTool lt) throws IOException {
        return CommandLineTools.checkText(contents, lt, false, -1, 0, 0, StringTools.ApiPrintMode.NORMAL_API, false, JLanguageTool.Level.DEFAULT, Collections.emptyList(), false);
    }

    public static int checkText(String contents, JLanguageTool lt, boolean isJsonFormat, int lineOffset) throws IOException {
        return CommandLineTools.checkText(contents, lt, isJsonFormat, -1, lineOffset, 0, StringTools.ApiPrintMode.NORMAL_API, false, JLanguageTool.Level.DEFAULT, Collections.emptyList(), false);
    }

    public static int checkText(String contents, JLanguageTool lt, boolean isJsonFormat, int lineOffset, JLanguageTool.Level level, boolean listUnknownWords) throws IOException {
        return CommandLineTools.checkText(contents, lt, isJsonFormat, -1, lineOffset, 0, StringTools.ApiPrintMode.NORMAL_API, listUnknownWords, level, Collections.emptyList(), false);
    }

    public static int checkText(String contents, JLanguageTool lt, boolean isJsonFormat, int lineOffset, JLanguageTool.Level level, boolean listUnknownWords, boolean verbose) throws IOException {
        return CommandLineTools.checkText(contents, lt, isJsonFormat, -1, lineOffset, 0, StringTools.ApiPrintMode.NORMAL_API, listUnknownWords, level, Collections.emptyList(), verbose);
    }

    public static int checkText(String contents, JLanguageTool lt, boolean isJsonFormat, int contextSize, int lineOffset, int prevMatches, StringTools.ApiPrintMode apiMode, boolean listUnknownWords, JLanguageTool.Level level, List<String> unknownWords, boolean verbose) throws IOException {
        if (contextSize == -1) {
            contextSize = 45;
        }
        long startTime = System.currentTimeMillis();
        List ruleMatches = lt.check(new AnnotatedTextBuilder().addText(contents).build(), true, JLanguageTool.ParagraphHandling.NORMAL, null, JLanguageTool.Mode.ALL, level);
        ruleMatches.parallelStream().forEach(r -> {
            r.setLine(r.getLine() + lineOffset);
            r.setEndLine(r.getEndLine() + lineOffset);
            r.getSuggestedReplacementObjects();
        });
        if (isJsonFormat) {
            RuleMatchesAsJsonSerializer serializer = new RuleMatchesAsJsonSerializer();
            String json = serializer.ruleMatchesToJson(ruleMatches, contents, contextSize, new DetectedLanguage(lt.getLanguage(), lt.getLanguage()));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            out.print(json);
        } else {
            CommandLineTools.printMatches(ruleMatches, prevMatches, contents, contextSize, lt.getLanguage(), verbose);
        }
        if (apiMode == StringTools.ApiPrintMode.NORMAL_API && !isJsonFormat) {
            SentenceTokenizer sentenceTokenizer = lt.getLanguage().getSentenceTokenizer();
            int sentenceCount = sentenceTokenizer.tokenize(contents).size();
            CommandLineTools.displayTimeStats(startTime, sentenceCount);
        }
        return ruleMatches.size();
    }

    private static void displayTimeStats(long startTime, long sentCount) {
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        float timeInSeconds = (float)time / 1000.0f;
        float sentencesPerSecond = (float)sentCount / timeInSeconds;
        System.out.printf(Locale.ENGLISH, "Time: %dms for %d sentences (%.1f sentences/sec)", time, sentCount, Float.valueOf(sentencesPerSecond));
        System.out.println();
    }

    public static void printMatches(List<RuleMatch> ruleMatches, int prevMatches, String contents, int contextSize, Language lang, boolean verbose) {
        int i = 1;
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(contextSize);
        for (RuleMatch match : ruleMatches) {
            AbstractPatternRule pRule;
            Rule rule = match.getRule();
            String output = i + prevMatches + ".) Line " + (match.getLine() + 1) + ", column " + match.getColumn() + ", Rule ID: " + match.getSpecificRuleId();
            if (rule instanceof AbstractPatternRule && (pRule = (AbstractPatternRule)rule).getSubId() != null) {
                output = output + "[" + pRule.getSubId() + "]";
            }
            output = output + " premium: " + Premium.get().isPremiumRule(match.getRule());
            int priorityForId = lang.getRulePriority(match.getRule());
            if (priorityForId != 0) {
                output = output + " prio=" + priorityForId;
            }
            if (verbose && rule instanceof AbstractPatternRule) {
                AbstractPatternRule pRule2 = (AbstractPatternRule)rule;
                output = output + " (line " + pRule2.getXmlLineNumber() + ")";
            }
            System.out.println(output);
            String msg = lang.toAdvancedTypography(match.getMessage());
            System.out.println("Message: " + msg);
            List replacements = match.getSuggestedReplacements();
            if (!replacements.isEmpty()) {
                replacements = replacements.subList(0, Math.min(5, replacements.size()));
                System.out.println("Suggestion: " + String.join((CharSequence)"; ", replacements));
            }
            System.out.println(contextTools.getPlainTextContext(match.getFromPos(), match.getToPos(), contents));
            if (match.getUrl() != null) {
                System.out.println("More info: " + match.getUrl());
            } else if (rule.getUrl() != null) {
                System.out.println("More info: " + rule.getUrl());
            }
            List tags = rule.getTags();
            if (!tags.isEmpty()) {
                System.out.println("Tags: " + tags);
            }
            if (i < ruleMatches.size()) {
                System.out.println();
            }
            ++i;
        }
    }

    public static int checkBitext(BitextReader reader, JLanguageTool srcLt, JLanguageTool trgLt, List<BitextRule> bRules) throws IOException {
        long startTime = System.currentTimeMillis();
        int contextSize = 45;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int matchCount = 0;
        int sentCount = 0;
        try (PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");){
            for (StringPair srcAndTrg : reader) {
                List curMatches = Tools.checkBitext((String)srcAndTrg.getSource(), (String)srcAndTrg.getTarget(), (JLanguageTool)srcLt, (JLanguageTool)trgLt, bRules);
                ArrayList<RuleMatch> fixedMatches = new ArrayList<RuleMatch>();
                for (RuleMatch thisMatch : curMatches) {
                    fixedMatches.add(trgLt.adjustRuleMatchPos(thisMatch, reader.getSentencePosition(), reader.getColumnCount(), reader.getLineCount(), reader.getCurrentLine(), null));
                }
                ruleMatches.addAll(fixedMatches);
                if (fixedMatches.size() > 0) {
                    CommandLineTools.printMatches(fixedMatches, matchCount, reader.getCurrentLine(), contextSize, trgLt.getLanguage(), false);
                    matchCount += fixedMatches.size();
                }
                ++sentCount;
            }
            CommandLineTools.displayTimeStats(startTime, sentCount);
        }
        return ruleMatches.size();
    }

    public static void profileRulesOnText(String contents, JLanguageTool lt) throws IOException {
        long tagEndTime;
        int iterationCount = 3;
        long[] workTime = new long[iterationCount];
        List rules = lt.getAllActiveRules();
        int ruleCount = rules.size();
        List sentences = lt.sentenceTokenize(contents);
        long analyzeStartTime = System.currentTimeMillis();
        ArrayList<AnalyzedSentence> rawAnalyzedSentences = new ArrayList<AnalyzedSentence>();
        for (String sentence : sentences) {
            rawAnalyzedSentences.add(lt.getRawAnalyzedSentence(sentence));
        }
        long analyzeEndTime = tagEndTime = System.currentTimeMillis();
        long analyzeTime = analyzeEndTime - analyzeStartTime;
        System.out.printf("Analyze time: %d ms, %.1f sent/sec\n\n", analyzeTime, Float.valueOf((float)sentences.size() / (float)analyzeTime));
        Language language = lt.getLanguage();
        List analyzedSentences = rawAnalyzedSentences.stream().map(s -> {
            try {
                AnalyzedSentence disambig = language.getDisambiguator().disambiguate(s);
                AnalyzedSentence analyzedSentence = new AnalyzedSentence(disambig.getTokens(), s.getTokens());
                if (language.getPostDisambiguationChunker() != null) {
                    language.getPostDisambiguationChunker().addChunkTags(Arrays.asList(analyzedSentence.getTokens()));
                }
                return analyzedSentence;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        long disambigEndTime = System.currentTimeMillis();
        long disambigTime = disambigEndTime - tagEndTime;
        System.out.printf("Disambig time: %d ms, %f sent/sec\n\n", disambigTime, Float.valueOf((float)sentences.size() / (float)disambigTime));
        System.out.printf("Testing %d rules%n", ruleCount);
        System.out.printf("%-40s%10s%10s%10s%15s\n", "Rule ID", "Time", "Sentences", "Matches", "Sentences per sec.");
        for (Rule rule : rules) {
            if (rule instanceof TextLevelRule) continue;
            int matchCount = 0;
            for (int k = 0; k < iterationCount; ++k) {
                long startTime = System.currentTimeMillis();
                for (AnalyzedSentence sentence : analyzedSentences) {
                    matchCount += rule.match(sentence).length;
                }
                long endTime = System.currentTimeMillis();
                workTime[k] = endTime - startTime;
            }
            long time = CommandLineTools.median(workTime);
            float timeInSeconds = (float)time / 1000.0f;
            float sentencesPerSecond = (float)sentences.size() / timeInSeconds;
            System.out.printf(Locale.ENGLISH, "%-40s%10d%10d%10d%15.1f\n", rule.getFullId(), time, sentences.size(), matchCount, Float.valueOf(sentencesPerSecond));
        }
        long ruleEndTime = System.currentTimeMillis();
        System.out.printf("\nTotal rule time: %d ms\n", (ruleEndTime - disambigEndTime) / (long)iterationCount);
    }

    private static long median(long[] m) {
        Arrays.sort(m);
        int middle = m.length / 2;
        if (m.length % 2 == 1) {
            return m[middle];
        }
        return (m[middle - 1] + m[middle]) / 2L;
    }

    public static void correctBitext(BitextReader reader, JLanguageTool sourceLt, JLanguageTool targetLt, List<BitextRule> bRules) throws IOException {
        for (StringPair srcAndTrg : reader) {
            List curMatches = Tools.checkBitext((String)srcAndTrg.getSource(), (String)srcAndTrg.getTarget(), (JLanguageTool)sourceLt, (JLanguageTool)targetLt, bRules);
            ArrayList<RuleMatch> fixedMatches = new ArrayList<RuleMatch>();
            for (RuleMatch thisMatch : curMatches) {
                fixedMatches.add(targetLt.adjustRuleMatchPos(thisMatch, 0, reader.getTargetColumnCount(), reader.getLineCount(), reader.getCurrentLine(), null));
            }
            if (fixedMatches.size() > 0) {
                System.out.println(CommandLineTools.correctTextFromMatches(srcAndTrg.getTarget(), fixedMatches));
                continue;
            }
            System.out.println(srcAndTrg.getTarget());
        }
    }

    private static String correctTextFromMatches(String contents, List<RuleMatch> matches) {
        StringBuilder sb = new StringBuilder(contents);
        ArrayList<String> errors = new ArrayList<String>();
        for (RuleMatch rm : matches) {
            List replacements = rm.getSuggestedReplacements();
            if (replacements.isEmpty()) continue;
            errors.add(sb.substring(rm.getFromPos(), rm.getToPos()));
        }
        int offset = 0;
        int counter = 0;
        for (RuleMatch rm : matches) {
            List replacements = rm.getSuggestedReplacements();
            if (replacements.isEmpty()) continue;
            if (((String)errors.get(counter)).equals(sb.substring(rm.getFromPos() - offset, rm.getToPos() - offset))) {
                sb.replace(rm.getFromPos() - offset, rm.getToPos() - offset, (String)replacements.get(0));
                offset += rm.getToPos() - rm.getFromPos() - ((String)replacements.get(0)).length();
            }
            ++counter;
        }
        return sb.toString();
    }
}

