/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.dependency.MinimumSpanningTreeParser;
import com.hankcs.hanlp.dependency.common.Edge;
import com.hankcs.hanlp.dependency.common.Node;
import com.hankcs.hanlp.model.bigram.WordNatureDependencyModel;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.GlobalObjectPool;
import java.util.List;

public class WordNatureDependencyParser
extends MinimumSpanningTreeParser {
    private WordNatureDependencyModel model;

    public WordNatureDependencyParser(WordNatureDependencyModel model) {
        this.model = model;
    }

    public WordNatureDependencyParser(String modelPath) {
        this.model = (WordNatureDependencyModel)GlobalObjectPool.get(modelPath);
        if (this.model != null) {
            return;
        }
        this.model = new WordNatureDependencyModel(modelPath);
        GlobalObjectPool.put(modelPath, this.model);
    }

    public WordNatureDependencyParser() {
        this(HanLP.Config.WordNatureModelPath);
    }

    public static CoNLLSentence compute(List<Term> termList) {
        return new WordNatureDependencyParser().parse(termList);
    }

    public static CoNLLSentence compute(String sentence) {
        return new WordNatureDependencyParser().parse(sentence);
    }

    @Override
    protected Edge makeEdge(Node[] nodeArray, int from, int to) {
        return this.model.getEdge(nodeArray[from], nodeArray[to]);
    }
}

