/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder;

import com.headius.invokebinder.Signature;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class SmartHandle {
    private final Signature signature;
    private final MethodHandle handle;

    SmartHandle(Signature signature, MethodHandle handle) {
        this.signature = signature;
        this.handle = handle;
    }

    public static SmartHandle from(Signature signature, MethodHandle handle) {
        return new SmartHandle(signature, handle);
    }

    public static SmartHandle findStaticQuiet(MethodHandles.Lookup lookup, Class<?> target2, String name2, Signature signature) {
        try {
            return new SmartHandle(signature, lookup.findStatic(target2, name2, signature.type()));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public Signature signature() {
        return this.signature;
    }

    public MethodHandle handle() {
        return this.handle;
    }

    public SmartHandle apply(int index2, Object arg2) {
        return new SmartHandle(this.signature.dropArg(index2), MethodHandles.insertArguments(this.handle, index2, arg2));
    }

    public SmartHandle apply(String name2, Object arg2) {
        return new SmartHandle(this.signature.dropArg(name2), MethodHandles.insertArguments(this.handle, this.signature.argOffset(name2), arg2));
    }

    public SmartHandle applyLast(Object arg2) {
        return new SmartHandle(this.signature.dropLast(), MethodHandles.insertArguments(this.handle, this.signature.type().parameterCount(), arg2));
    }

    public SmartHandle drop(String beforeName, String newName, Class<?> type2) {
        return new SmartHandle(this.signature.insertArg(beforeName, newName, type2), MethodHandles.dropArguments(this.handle, this.signature.argOffset(beforeName), new Class[]{type2}));
    }

    public SmartHandle drop(int index2, String newName, Class<?> type2) {
        return new SmartHandle(this.signature.insertArg(index2, newName, type2), MethodHandles.dropArguments(this.handle, index2, new Class[]{type2}));
    }

    public SmartHandle dropLast(String newName, Class<?> type2) {
        return new SmartHandle(this.signature.appendArg(newName, type2), MethodHandles.dropArguments(this.handle, this.signature.argOffset(newName), new Class[]{type2}));
    }

    public MethodHandle guard(MethodHandle target2, MethodHandle fallback) {
        return MethodHandles.guardWithTest(this.handle, target2, fallback);
    }

    public SmartHandle guard(SmartHandle target2, SmartHandle fallback) {
        return new SmartHandle(target2.signature, MethodHandles.guardWithTest(this.handle, target2.handle, fallback.handle));
    }

    public SmartHandle bindTo(Object obj) {
        return new SmartHandle(this.signature.dropFirst(), this.handle.bindTo(obj));
    }

    public SmartHandle convert(MethodType incoming) {
        return new SmartHandle(new Signature(incoming, this.signature.argNames()), this.handle.asType(incoming));
    }

    public SmartHandle convert(Class<?> returnType, Class<?> ... argTypes) {
        return this.convert(MethodType.methodType(returnType, argTypes));
    }

    public SmartHandle convert(Signature incoming) {
        return new SmartHandle(incoming, this.handle.asType(incoming.type()));
    }

    public SmartHandle cast(MethodType incoming) {
        return new SmartHandle(new Signature(incoming, this.signature.argNames()), MethodHandles.explicitCastArguments(this.handle, incoming));
    }

    public SmartHandle cast(Signature incoming) {
        return new SmartHandle(incoming, MethodHandles.explicitCastArguments(this.handle, incoming.type()));
    }

    public SmartHandle cast(Class<?> returnType, Class<?> ... argTypes) {
        return this.cast(MethodType.methodType(returnType, argTypes));
    }

    public SmartHandle returnValue(Class<?> type2, Object value2) {
        return new SmartHandle(this.signature.changeReturn(type2), MethodHandles.filterReturnValue(this.handle, MethodHandles.constant(type2, value2)));
    }

    public String toString() {
        return this.signature.toString() + "=>" + this.handle;
    }
}

