/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities the gir-to-d pakage


module glib.StaticMutex;

private import glib.MemorySlice;
private import glib.Mutex;
private import glib.c.functions;
public  import glib.c.types;


/**
 * A #GStaticMutex works like a #GMutex.
 * 
 * Prior to GLib 2.32, GStaticMutex had the significant advantage
 * that it doesn't need to be created at run-time, but can be defined
 * at compile-time. Since 2.32, #GMutex can be statically allocated
 * as well, and GStaticMutex has been deprecated.
 * 
 * Here is a version of our give_me_next_number() example using
 * a GStaticMutex:
 * |[
 * int
 * give_me_next_number (void)
 * {
 * static int current_number = 0;
 * int ret_val;
 * static GStaticMutex mutex = G_STATIC_MUTEX_INIT;
 * 
 * g_static_mutex_lock (&mutex);
 * ret_val = current_number = calc_next_number (current_number);
 * g_static_mutex_unlock (&mutex);
 * 
 * return ret_val;
 * }
 * ]|
 * 
 * Sometimes you would like to dynamically create a mutex. If you don't
 * want to require prior calling to g_thread_init(), because your code
 * should also be usable in non-threaded programs, you are not able to
 * use g_mutex_new() and thus #GMutex, as that requires a prior call to
 * g_thread_init(). In these cases you can also use a #GStaticMutex.
 * It must be initialized with g_static_mutex_init() before using it
 * and freed with with g_static_mutex_free() when not needed anymore to
 * free up any allocated resources.
 * 
 * Even though #GStaticMutex is not opaque, it should only be used with
 * the following functions, as it is defined differently on different
 * platforms.
 * 
 * All of the g_static_mutex_* functions apart from
 * g_static_mutex_get_mutex() can also be used even if g_thread_init()
 * has not yet been called. Then they do nothing, apart from
 * g_static_mutex_trylock() which does nothing but returning %TRUE.
 * 
 * All of the g_static_mutex_* functions are actually macros. Apart from
 * taking their addresses, you can however use them as if they were
 * functions.
 */
public final class StaticMutex
{
	/** the main Gtk struct */
	protected GStaticMutex* gStaticMutex;
	protected bool ownedRef;

	/** Get the main Gtk struct */
	public GStaticMutex* getStaticMutexStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return gStaticMutex;
	}

	/** the main Gtk struct as a void* */
	protected void* getStruct()
	{
		return cast(void*)gStaticMutex;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (GStaticMutex* gStaticMutex, bool ownedRef = false)
	{
		this.gStaticMutex = gStaticMutex;
		this.ownedRef = ownedRef;
	}

	~this ()
	{
		if ( ownedRef )
			g_static_mutex_free(gStaticMutex);
	}


	/** */
	public @property Mutex mutex()
	{
		return new Mutex(gStaticMutex.mutex, false);
	}

	/** Ditto */
	public @property void mutex(Mutex value)
	{
		gStaticMutex.mutex = value.getMutexStruct();
	}

	/**
	 * Releases all resources allocated to @mutex.
	 *
	 * You don't have to call this functions for a #GStaticMutex with an
	 * unbounded lifetime, i.e. objects declared 'static', but if you have
	 * a #GStaticMutex as a member of a structure and the structure is
	 * freed, you should also free the #GStaticMutex.
	 *
	 * Calling g_static_mutex_free() on a locked mutex may result in
	 * undefined behaviour.
	 *
	 * Deprecated: Use g_mutex_clear()
	 */
	public void free()
	{
		g_static_mutex_free(gStaticMutex);
		ownedRef = false;
	}

	/** */
	public Mutex getMutexImpl()
	{
		auto __p = g_static_mutex_get_mutex_impl(gStaticMutex);

		if(__p is null)
		{
			return null;
		}

		return new Mutex(cast(GMutex*) __p);
	}

	/**
	 * Initializes @mutex.
	 * Alternatively you can initialize it with %G_STATIC_MUTEX_INIT.
	 *
	 * Deprecated: Use g_mutex_init()
	 */
	public void init()
	{
		g_static_mutex_init(gStaticMutex);
	}
}
